/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.topology;

import java.net.InetAddress;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.CompareUtil;
import whatap.util.HashUtil;

public class LINK {
    public byte[] ip;
    public int port;

    public String toString() {
        if (this.ip == null) {
            return "0.0.0.0:" + this.port;
        }
        try {
            return InetAddress.getByAddress(this.ip).getHostAddress() + ":" + this.port;
        }
        catch (Exception e) {
            return "0.0.0.0:" + this.port;
        }
    }

    public static LINK create(String ipStr, int port) {
        LINK k = new LINK();
        try {
            k.ip = InetAddress.getByName(ipStr).getAddress();
        }
        catch (Exception e) {
            k.ip = new byte[4];
        }
        k.port = port;
        return k;
    }

    public boolean include(LINK k) {
        if (!CompareUtil.equals(this.ip, k.ip)) {
            return false;
        }
        if (this.port == 0) {
            return true;
        }
        return this.port == k.port;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        LINK k = (LINK)o;
        if (!CompareUtil.equals(this.ip, k.ip)) {
            return false;
        }
        return this.port == k.port;
    }

    public int hashCode() {
        return HashUtil.hash(this.ip) | this.port;
    }

    public LINK toBytes(DataOutputX out) {
        out.writeBlob(this.ip);
        out.writeInt(this.port);
        return this;
    }

    public LINK toObject(DataInputX in) {
        this.ip = in.readBlob();
        this.port = in.readInt();
        return this;
    }

    public static void main(String[] args) {
        LINK k = new LINK();
        k.ip = new byte[16];
        k.port = 123;
        System.out.println(LINK.create("0:0:0:0:0:0:0:0", 123));
    }
}

