/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.db;

import java.io.IOException;
import java.util.Enumeration;
import whatap.io.DataIOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.H3;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.value.IntMapValue;
import whatap.util.HashUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSqlStatPack
extends AbstractPack {
    public static final short ALL = 0;
    public static final short DB = 1;
    public short tag;
    public StringKeyLinkedMap<IntKeyLinkedMap<IntMapValue>> table = new StringKeyLinkedMap();

    public String[] getKeyNames() {
        return this.table.keyArray();
    }

    public int size() {
        return this.table.size();
    }

    public int size(String keyName) {
        IntKeyLinkedMap<IntMapValue> m = this.table.get(keyName);
        return m == null ? 0 : m.size();
    }

    public void put(String keyName, int sql, IntMapValue r) {
        IntKeyLinkedMap<IntMapValue> m = this.table.get(keyName);
        if (m == null) {
            m = new IntKeyLinkedMap();
            this.table.put(keyName, m);
        }
        m.put(sql, r);
    }

    public void put(String keyName, IntKeyLinkedMap<IntMapValue> r) {
        this.table.put(keyName, r);
    }

    public IntMapValue get(String keyName, int sql) {
        IntKeyLinkedMap<IntMapValue> dbm = this.table.get(keyName);
        return dbm != null ? dbm.get(sql) : null;
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeShort(this.table.size());
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<IntKeyLinkedMap<IntMapValue>>> en = this.table.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<IntKeyLinkedMap<IntMapValue>> ent = en.nextElement();
            dout.writeText(ent.getKey());
            dout.writeShort(ent.getValue().size());
            Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<IntMapValue>> en2 = ent.getValue().entries();
            while (en2.hasMoreElements()) {
                IntKeyLinkedMap.IntKeyLinkedEntry<IntMapValue> ent2 = en2.nextElement();
                dout.writeInt(ent2.getKey());
                try {
                    ent2.getValue().write(dout);
                }
                catch (IOException e) {
                    throw new DataIOException(e);
                }
            }
        }
        dout.writeShort(this.tag);
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        int sz = din.readShort();
        for (int i = 0; i < sz; ++i) {
            String keyName = din.readText();
            int sqlSz = din.readShort();
            IntKeyLinkedMap<IntMapValue> sqlSet = new IntKeyLinkedMap<IntMapValue>();
            for (int j = 0; j < sqlSz; ++j) {
                int key = din.readInt();
                try {
                    sqlSet.put(key, (IntMapValue)new IntMapValue().read(din));
                    continue;
                }
                catch (IOException e) {
                    throw new DataIOException(e);
                }
            }
            this.table.put(keyName, sqlSet);
        }
        this.tag = din.readShort();
        return this;
    }

    @Override
    public short getPackType() {
        return 16399;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Altibase {
        public static final short USERNAME = 2;
        public static final short COMM_NAME = 3;
        public static final short CLIENT_APP = 4;
        public static final short MODULE = 5;
        public static final int sqlHash = HashUtil.hash("sqlHash");
        public static final int username = HashUtil.hash("username");
        public static final int comm_name = HashUtil.hash("comm_name");
        public static final int client_app = HashUtil.hash("client_app");
        public static final int module = HashUtil.hash("module");
        public static final int sql_elapse = HashUtil.hash("sql elapse");
        public static final int sql_elapse_wait = HashUtil.hash("sql elapse wait");
        public static final int sql_elapse_max = HashUtil.hash("sql elapse max");
        public static final int sql_execute_cnt = HashUtil.hash("sql execute cnt");
        public static final int stat1 = HashUtil.hash("stat1");
        public static final int stat2 = HashUtil.hash("stat2");
        public static final int stat3 = HashUtil.hash("stat3");
        public static final int stat4 = HashUtil.hash("stat4");
        public static final int stat5 = HashUtil.hash("stat5");

        public static synchronized void send(H3<Integer, String, String> handler) {
            try {
                handler.process(sqlHash, "sqlHash", null);
                handler.process(username, "username", null);
                handler.process(comm_name, "comm_name", null);
                handler.process(client_app, "client_app", null);
                handler.process(module, "module", null);
                handler.process(sql_elapse, "sql elapse", null);
                handler.process(sql_elapse_wait, "sql elapse wait", null);
                handler.process(sql_elapse_max, "sql elapse max", null);
                handler.process(sql_execute_cnt, "sql execute cnt", null);
                handler.process(stat1, "stat1", null);
                handler.process(stat2, "stat2", null);
                handler.process(stat3, "stat3", null);
                handler.process(stat4, "stat4", null);
                handler.process(stat5, "stat5", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cubrid {
        public static final short USER = 2;
        public static final short HOST = 3;
        public static final short PROGRAM = 4;
        public static final int sqlHash = HashUtil.hash("sqlHash");
        public static final int user = HashUtil.hash("user");
        public static final int host = HashUtil.hash("host");
        public static final int db = HashUtil.hash("db");
        public static final int program = HashUtil.hash("program");
        public static final int sql_elapse = HashUtil.hash("sql elapse");
        public static final int sql_elapse_max = HashUtil.hash("sql elapse max");
        public static final int sql_execute_cnt = HashUtil.hash("sql execute cnt");

        public static synchronized void send(H3<Integer, String, String> handler) {
            try {
                handler.process(sqlHash, "sqlHash", null);
                handler.process(user, "user", null);
                handler.process(host, "host", null);
                handler.process(db, "db", null);
                handler.process(db, "program", null);
                handler.process(sql_elapse, "sql elapse", null);
                handler.process(sql_elapse_max, "sql elapse max", null);
                handler.process(sql_execute_cnt, "sql execute cnt", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tibero {
        public static final short USER = 2;
        public static final short MACHINE = 3;
        public static final short PROGRAM = 4;
        public static final short MODULE = 5;
        public static final short OSUSER = 6;
        public static final int sqlHash = HashUtil.hash("sqlHash");
        public static final int schemaName = HashUtil.hash("schemaName");
        public static final int machine = HashUtil.hash("machine");
        public static final int program = HashUtil.hash("program");
        public static final int module = HashUtil.hash("module");
        public static final int osUser = HashUtil.hash("osUser");
        public static final int sql_id = HashUtil.hash("sql_id");
        public static final int sql_elapse = HashUtil.hash("sql elapse");
        public static final int sql_elapse_wait = HashUtil.hash("sql elapse wait");
        public static final int sql_elapse_max = HashUtil.hash("sql elapse max");
        public static final int sql_execute_cnt = HashUtil.hash("sql execute cnt");
        public static final int stat1 = HashUtil.hash("stat1");
        public static final int stat2 = HashUtil.hash("stat2");
        public static final int stat3 = HashUtil.hash("stat3");
        public static final int stat4 = HashUtil.hash("stat4");
        public static final int stat5 = HashUtil.hash("stat5");

        public static synchronized void send(H3<Integer, String, String> handler) {
            try {
                handler.process(sqlHash, "sqlHash", null);
                handler.process(schemaName, "schemaName", null);
                handler.process(machine, "machine", null);
                handler.process(program, "program", null);
                handler.process(module, "module", null);
                handler.process(osUser, "osUser", null);
                handler.process(sql_id, "sql_id", null);
                handler.process(sql_elapse, "sql elapse", null);
                handler.process(sql_elapse_wait, "sql elapse wait", null);
                handler.process(sql_elapse_max, "sql elapse max", null);
                handler.process(sql_execute_cnt, "sql execute cnt", null);
                handler.process(stat1, "stat1", null);
                handler.process(stat2, "stat2", null);
                handler.process(stat3, "stat3", null);
                handler.process(stat4, "stat4", null);
                handler.process(stat5, "stat5", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Mssql {
        public static final short USER = 2;
        public static final short HOST = 3;
        public static final short APPLICATION = 4;
        public static final short CLIENT = 5;
        public static final int sqlHash = HashUtil.hash("sqlHash");
        public static final int db = HashUtil.hash("db");
        public static final int host = HashUtil.hash("host");
        public static final int application = HashUtil.hash("application");
        public static final int user = HashUtil.hash("user");
        public static final int client = HashUtil.hash("client");
        public static final int sql_elapse = HashUtil.hash("sql elapse");
        public static final int sql_elapse_max = HashUtil.hash("sql elapse max");
        public static final int sql_execute_cnt = HashUtil.hash("sql execute cnt");
        public static final int stat1 = HashUtil.hash("stat1");
        public static final int stat2 = HashUtil.hash("stat2");
        public static final int stat3 = HashUtil.hash("stat3");
        public static final int stat4 = HashUtil.hash("stat4");

        public static synchronized void send(H3<Integer, String, String> handler) {
            try {
                handler.process(sqlHash, "sqlHash", null);
                handler.process(db, "db", null);
                handler.process(host, "host", null);
                handler.process(application, "application", null);
                handler.process(user, "user", null);
                handler.process(client, "client", null);
                handler.process(sql_elapse, "sql elapse", null);
                handler.process(sql_elapse_max, "sql elapse max", null);
                handler.process(sql_execute_cnt, "sql execute cnt", null);
                handler.process(stat1, "stat1", null);
                handler.process(stat2, "stat2", null);
                handler.process(stat3, "stat3", null);
                handler.process(stat4, "stat4", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Mysql {
        public static final short USER = 2;
        public static final short HOST = 3;
        public static final int sqlHash = HashUtil.hash("sqlHash");
        public static final int user = HashUtil.hash("user");
        public static final int host = HashUtil.hash("host");
        public static final int db = HashUtil.hash("db");
        public static final int sql_elapse = HashUtil.hash("sql elapse");
        public static final int sql_elapse_max = HashUtil.hash("sql elapse max");
        public static final int sql_execute_cnt = HashUtil.hash("sql execute cnt");

        public static synchronized void send(H3<Integer, String, String> handler) {
            try {
                handler.process(sqlHash, "sqlHash", null);
                handler.process(user, "user", null);
                handler.process(host, "host", null);
                handler.process(db, "db", null);
                handler.process(sql_elapse, "sql elapse", null);
                handler.process(sql_elapse_max, "sql elapse max", null);
                handler.process(sql_execute_cnt, "sql execute cnt", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pg {
        public static final short USER = 2;
        public static final short HOST = 3;
        public static final short APPLICATION = 4;
        public static final int sqlHash = HashUtil.hash("sqlHash");
        public static final int user = HashUtil.hash("user");
        public static final int host = HashUtil.hash("host");
        public static final int db = HashUtil.hash("db");
        public static final int application = HashUtil.hash("application");
        public static final int query_id = HashUtil.hash("query id");
        public static final int sql_elapse = HashUtil.hash("sql elapse");
        public static final int sql_elapse_wait = HashUtil.hash("sql elapse wait");
        public static final int sql_elapse_max = HashUtil.hash("sql elapse max");
        public static final int sql_execute_cnt = HashUtil.hash("sql execute cnt");

        public static synchronized void send(H3<Integer, String, String> handler) {
            try {
                handler.process(sqlHash, "sqlHash", null);
                handler.process(user, "user", null);
                handler.process(host, "host", null);
                handler.process(db, "db", null);
                handler.process(application, "application", null);
                handler.process(query_id, "query id", null);
                handler.process(sql_elapse, "sql elapse", null);
                handler.process(sql_elapse_wait, "sql elapse wait", null);
                handler.process(sql_elapse_max, "sql elapse max", null);
                handler.process(sql_execute_cnt, "sql execute cnt", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Oracle {
        public static final short SCHEMANAME = 2;
        public static final short MACHINE = 3;
        public static final short PROGRAM = 4;
        public static final short MODULE = 5;
        public static final short OSUSER = 6;
        public static final int sqlHash = HashUtil.hash("sqlHash");
        public static final int schemaName = HashUtil.hash("schemaName");
        public static final int machine = HashUtil.hash("machine");
        public static final int program = HashUtil.hash("program");
        public static final int module = HashUtil.hash("module");
        public static final int osUser = HashUtil.hash("osUser");
        public static final int sql_id = HashUtil.hash("sql_id");
        public static final int sql_elapse = HashUtil.hash("sql elapse");
        public static final int sql_elapse_wait = HashUtil.hash("sql elapse wait");
        public static final int sql_elapse_max = HashUtil.hash("sql elapse max");
        public static final int sql_execute_cnt = HashUtil.hash("sql execute cnt");
        public static final int stat1 = HashUtil.hash("stat1");
        public static final int stat2 = HashUtil.hash("stat2");
        public static final int stat3 = HashUtil.hash("stat3");
        public static final int stat4 = HashUtil.hash("stat4");
        public static final int stat5 = HashUtil.hash("stat5");

        public static synchronized void send(H3<Integer, String, String> handler) {
            try {
                handler.process(sqlHash, "sqlHash", null);
                handler.process(schemaName, "schemaName", null);
                handler.process(machine, "machine", null);
                handler.process(program, "program", null);
                handler.process(module, "module", null);
                handler.process(osUser, "osUser", null);
                handler.process(sql_id, "sql_id", null);
                handler.process(sql_elapse, "sql elapse", null);
                handler.process(sql_elapse_wait, "sql elapse wait", null);
                handler.process(sql_elapse_max, "sql elapse max", null);
                handler.process(sql_execute_cnt, "sql execute cnt", null);
                handler.process(stat1, "stat1", null);
                handler.process(stat2, "stat2", null);
                handler.process(stat3, "stat3", null);
                handler.process(stat4, "stat4", null);
                handler.process(stat5, "stat5", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

