/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.bsm;

import java.util.ArrayList;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.pack.bsm.BsmRecord;
import whatap.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BsmRecordPack
extends AbstractPack {
    public byte[] records;
    public int record_count;

    @Override
    public short getPackType() {
        return 5889;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BsmRecordPack ");
        sb.append(super.toString());
        sb.append(",records=" + this.record_count);
        sb.append(",bytes=" + ArrayUtil.len(this.records));
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeDecimal(this.record_count);
        dout.writeBlob(this.records);
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.record_count = (int)din.readDecimal();
        this.records = din.readBlob();
        return this;
    }

    public BsmRecordPack setRecords(List<BsmRecord> items) {
        DataOutputX o = new DataOutputX();
        o.writeDecimal(items.size());
        for (int i = 0; i < items.size(); ++i) {
            items.get(i).write(o);
        }
        this.records = o.toByteArray();
        this.record_count = items.size();
        return this;
    }

    public List<BsmRecord> getRecords() {
        ArrayList<BsmRecord> items = new ArrayList<BsmRecord>();
        if (this.records == null) {
            return items;
        }
        DataInputX in = new DataInputX(this.records);
        int size = (int)in.readDecimal();
        for (int i = 0; i < size; ++i) {
            items.add(new BsmRecord().read(in));
        }
        return items;
    }
}

