/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.Enumeration;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.slog.SLog;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.IntIntMap;
import whatap.util.LinkedMap;
import whatap.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatUserAgentPack1
extends AbstractPack {
    public IntIntMap userAgents = new IntIntMap();
    public LinkedMap<Pair<String, String>, Integer> osbrTab = null;
    private short packType;
    public long dataStartTime;

    public StatUserAgentPack1() {
        this(4608);
    }

    public StatUserAgentPack1(short type) {
        this.packType = type;
    }

    @Override
    public short getPackType() {
        return this.packType;
    }

    @Override
    public String toString() {
        SLog slog = SLog.n("pack", this.getClass().getSimpleName());
        super.slog(slog);
        slog.a("records", this.userAgents.size());
        slog.a("type", this.getPackType());
        slog.a("packType", this.packType);
        slog.a("startTime", DateUtil.timestamp(this.dataStartTime));
        return slog.green();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeDecimal(this.userAgents.size());
        Enumeration<IntIntMap.IntIntEntry> en = this.userAgents.entries();
        while (en.hasMoreElements()) {
            IntIntMap.IntIntEntry e = en.nextElement();
            dout.writeInt(e.getKey());
            dout.writeInt(e.getValue());
        }
        if (this.packType == 4608) {
            return;
        }
        if (this.osbrTab == null) {
            dout.writeDecimal(0L);
        } else {
            dout.writeDecimal(this.osbrTab.size());
            Enumeration<LinkedMap.LinkedEntry<Pair<String, String>, Integer>> en2 = this.osbrTab.entries();
            while (en2.hasMoreElements()) {
                LinkedMap.LinkedEntry<Pair<String, String>, Integer> ent = en2.nextElement();
                dout.writeText(ent.getKey().getLeft());
                dout.writeText(ent.getKey().getRight());
                dout.writeInt(ent.getValue());
            }
        }
        if (this.packType == 4609) {
            return;
        }
        DataOutputX o = new DataOutputX();
        o.writeDecimal(this.dataStartTime);
        dout.writeBlob(o.toByteArray());
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        int cnt = (int)din.readDecimal();
        this.userAgents = new IntIntMap(cnt, 1.0f);
        for (int i = 0; i < cnt; ++i) {
            int hash = din.readInt();
            int count = din.readInt();
            this.userAgents.put(hash, count);
        }
        if (this.packType == 4608) {
            return this;
        }
        int n = (int)din.readDecimal();
        if (n == 0) {
            this.osbrTab = null;
            return this;
        }
        this.osbrTab = new LinkedMap(cnt, 1.0f);
        for (int i = 0; i < n; ++i) {
            String os = din.readText();
            String br = din.readText();
            int c = din.readInt();
            this.osbrTab.put(new Pair<String, String>(os, br), c);
        }
        if (this.packType == 4609) {
            return this;
        }
        DataInputX in = new DataInputX(din.readBlob());
        this.dataStartTime = in.readDecimal();
        return this;
    }

    public void initOsBr() {
        if (this.osbrTab == null) {
            this.osbrTab = new LinkedMap(this.userAgents.size(), 1.0f);
        }
    }

    public void addOsBr(Pair<String, String> osBrowser, int value) {
        this.osbrTab.put(osBrowser, CastUtil.cint(this.osbrTab.get(osBrowser)) + value);
    }
}

