/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.pack.TransactionRec;
import whatap.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatTransactionPack1
extends AbstractPack {
    public byte[] records;
    public int record_count;
    public int spec;
    public byte version = (byte)4;
    public long dataStartTime;
    public long dataEndTime;
    private short packType;

    public StatTransactionPack1() {
        this(2305);
    }

    public StatTransactionPack1(short packType) {
        this.packType = packType;
    }

    @Override
    public short getPackType() {
        return this.packType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StatTransaction1 ");
        sb.append(super.toString());
        sb.append(",records=" + this.record_count);
        sb.append(",bytes=" + ArrayUtil.len(this.records));
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeBlob(this.records);
        dout.writeDecimal(this.record_count);
        dout.writeByte(0);
        dout.writeDecimal(this.spec);
        if (this.packType == 2305) {
            return;
        }
        DataOutputX o = new DataOutputX();
        o.writeDecimal(this.dataStartTime);
        o.writeDecimal(this.dataEndTime);
        o.writeByte(this.version);
        dout.writeBlob(o.toByteArray());
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.records = din.readBlob();
        this.record_count = (int)din.readDecimal();
        byte reserved = din.readByte();
        this.spec = (int)din.readDecimal();
        if (this.packType == 2305) {
            return this;
        }
        DataInputX in = new DataInputX(din.readBlob());
        this.dataStartTime = in.readDecimal();
        if (in.available() > 0) {
            this.dataEndTime = in.readDecimal();
        }
        if (in.available() > 0) {
            this.version = in.readByte();
        }
        return this;
    }

    public StatTransactionPack1 setRecords(int size, Enumeration<TransactionRec> items) {
        DataOutputX o = new DataOutputX();
        o.writeShort(size);
        for (int i = 0; i < size; ++i) {
            TransactionRec.writeRec(o, items.nextElement(), this.version);
        }
        this.records = o.toByteArray();
        this.record_count = size;
        return this;
    }

    public StatTransactionPack1 setRecords(List<TransactionRec> items) {
        DataOutputX o = new DataOutputX();
        o.writeShort(items.size());
        for (int i = 0; i < items.size(); ++i) {
            TransactionRec.writeRec(o, items.get(i), this.version);
        }
        this.records = o.toByteArray();
        this.record_count = items.size();
        return this;
    }

    public List<TransactionRec> getRecords() {
        ArrayList<TransactionRec> items = new ArrayList<TransactionRec>();
        if (this.records == null) {
            return null;
        }
        try {
            DataInputX in = new DataInputX(this.records);
            int size = in.readShort() & 0xFFFF;
            for (int i = 0; i < size; ++i) {
                items.add(TransactionRec.readRec(in));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return items;
    }
}

