/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Comparator;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfDebug;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.var.L2;
import whatap.util.AnsiPrint;
import whatap.util.CompareUtil;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.FormatUtil;
import whatap.util.LongEnumer;
import whatap.util.LongKeyLinkedMap;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class CpuProfile
extends Thread {
    private static CpuProfile instance = null;
    Configure conf = Configure.getInstance();
    private LongKeyLinkedMap<L2> lastValTable = new LongKeyLinkedMap<L2>(){

        @Override
        protected L2 create(long key) {
            return new L2();
        }
    }.setMax(2000);

    public static final synchronized CpuProfile getInstance() {
        if (instance == null) {
            instance = new CpuProfile();
            instance.setDaemon(true);
            instance.start();
            ThreadNameUtil.whatap(instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        int trigger = ConfDebug.debug_cpu_boot_start ? -1 : ConfDebug.debug_cpu_trigger;
        File root = new File(System.getProperty("whatap.home", "."), "dump");
        if (!root.exists()) {
            root.mkdirs();
        }
        String time = DateUtil.ymdhms(DateUtil.currentTime());
        int dump_id = Integer.MAX_VALUE;
        long lastCpu = SysJMX.getProcessCPU();
        long[] lastGc = SysJMX.getCurrentProcGcInfo();
        while (true) {
            block11: {
                PrintWriter out;
                ThreadUtil.sleep(ConfDebug.debug_cpu_interval);
                if (!ConfDebug.debug_cpu_enabled) continue;
                if (trigger != ConfDebug.debug_cpu_trigger) {
                    dump_id = 0;
                    time = DateUtil.ymdhms(DateUtil.currentTime());
                    this.lastValTable.clear();
                    trigger = ConfDebug.debug_cpu_trigger;
                }
                if (dump_id >= ConfDebug.debug_cpu_dump_count) continue;
                SecurityMaster secu = SecurityMaster.getInstance();
                if (dump_id == 0) {
                    try {
                        lastCpu = SysJMX.getProcessCPU();
                        lastGc = SysJMX.getCurrentProcGcInfo();
                        this.process(null);
                    }
                    catch (Throwable throwable) {}
                } else {
                    out = null;
                    File file = CpuProfile.getDumpFile(root, "whatap-cpu-" + secu.PCODE + "-" + secu.ONAME, time);
                    out = new PrintWriter(new FileWriter(file, true));
                    out.println();
                    long nowCpu = SysJMX.getProcessCPU();
                    long[] nowGc = SysJMX.getCurrentProcGcInfo();
                    StringBuffer sb = new StringBuffer();
                    sb.append(AnsiPrint.green("#" + dump_id + " Time: " + DateUtil.timestamp()));
                    sb.append(AnsiPrint.green(" @cpu ")).append(FormatUtil.print(nowCpu - lastCpu, "#,##0"));
                    sb.append(AnsiPrint.green(" @gc ")).append(FormatUtil.print(nowGc[0] - lastGc[0], "#,##0"));
                    sb.append(AnsiPrint.green(" @gcTime ")).append(FormatUtil.print(nowGc[1] - lastGc[1], "#,##0"));
                    lastCpu = nowCpu;
                    lastGc = nowGc;
                    out.println(sb);
                    this.process(out);
                    out.flush();
                    FileUtil.close(out);
                }
                break block11;
                catch (Throwable throwable) {
                    FileUtil.close(out);
                    catch (Throwable throwable2) {
                        FileUtil.close(out);
                        throw throwable2;
                    }
                }
            }
            ++dump_id;
        }
    }

    public static File getDumpFile(File root, String prefix, String time) {
        String name = prefix + "." + time + ".wdmp";
        return new File(root, name);
    }

    private void process(PrintWriter out) {
        long id;
        LongKeyLinkedMap<VALUE> thisList = new LongKeyLinkedMap<VALUE>();
        ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
        long[] thread = tmb.getAllThreadIds();
        for (int i = 0; i < thread.length; ++i) {
            ThreadInfo fo = tmb.getThreadInfo(thread[i]);
            id = fo.getThreadId();
            String name = fo.getThreadName();
            long mem = SysJMX.getThreadAllocBytes(thread[i]);
            long cpu = tmb.getThreadCpuTime(thread[i]) / 1000000L;
            L2 v = this.lastValTable.intern(id);
            long dcpu = cpu - v.v1;
            long dmem = mem - v.v2;
            v.v1 = cpu;
            v.v2 = mem;
            thisList.put(id, new VALUE(name, cpu, mem, dcpu, dmem));
        }
        if (out == null) {
            return;
        }
        thisList.sort(new Comparator<LongKeyLinkedMap.LongKeyLinkedEntry<VALUE>>(){

            @Override
            public int compare(LongKeyLinkedMap.LongKeyLinkedEntry<VALUE> o1, LongKeyLinkedMap.LongKeyLinkedEntry<VALUE> o2) {
                int d = CompareUtil.compareTo(o2.getValue().dmem, o1.getValue().dmem);
                if (d != 0) {
                    return d;
                }
                d = CompareUtil.compareTo(o2.getValue().dcpu, o1.getValue().dcpu);
                if (d != 0) {
                    return d;
                }
                return CompareUtil.compareTo(o2.getKey(), o1.getKey());
            }
        });
        LongEnumer en = thisList.keys();
        for (int i = 0; i < ConfDebug.debug_cpu_dump_thread_count && en.hasMoreElements(); ++i) {
            id = en.nextLong();
            VALUE v = (VALUE)thisList.get(id);
            out.println("");
            out.print(":::thread::: " + id + " ");
            out.print(v.name + " ");
            out.print("cpu " + FormatUtil.print(v.cpu, "#,##0"));
            out.print(AnsiPrint.green(" @cpu " + FormatUtil.print(v.dcpu, "#,##0")));
            out.print(" mem " + FormatUtil.print(v.mem, "#,##0"));
            out.print(AnsiPrint.green(" @mem " + FormatUtil.print(v.dmem, "#,##0")));
            TraceContext ctx = TraceContextManager.getContext(id);
            if (ctx != null) {
                out.print(" :::tx::: " + ctx.txid + " " + ctx.service_name + " ");
                out.print(ctx.getElapsedTime() + "ms ");
                out.print(v.cpu - ctx.start_cpu + "cpu");
                if (ctx.start_malloc > 0L) {
                    out.print(v.mem - ctx.start_malloc + "mem");
                }
            }
            out.println("");
            try {
                CpuProfile.printStack(out, tmb.getThreadInfo(id, 500));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void printStack(PrintWriter out, ThreadInfo f) {
        if (f == null) {
            return;
        }
        StackTraceElement[] se = f.getStackTrace();
        if (se != null) {
            for (int i = 0; i < se.length; ++i) {
                if (se[i] == null) continue;
                out.println("\t" + se[i]);
            }
        }
    }

    private static class VALUE {
        String name;
        long cpu;
        long mem;
        long dcpu;
        long dmem;

        public VALUE(String name, long cpu, long mem, long dcpu, long dmem) {
            this.name = name;
            this.cpu = cpu;
            this.mem = mem;
            this.dcpu = dcpu;
            this.dmem = dmem;
        }
    }
}

