/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.util;

import java.lang.instrument.ClassDefinition;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.boot.AgentBoot;
import whatap.agent.stat.StatError;
import whatap.agent.util.LeakErrorData;
import whatap.util.RequestQueue;
import whatap.util.SystemUtil;

public class AsyncRunner
extends Thread {
    private static AsyncRunner instance = null;
    private RequestQueue<Object> queue = new RequestQueue(1024);
    Configure conf = Configure.getInstance();

    public static final synchronized AsyncRunner getInstance() {
        if (instance == null) {
            instance = new AsyncRunner();
            instance.setDaemon(true);
            instance.setName("WhaTap-AsyncRunner");
            instance.start();
        }
        return instance;
    }

    public void add(ClassLoader loader, String classname, byte[] body) {
        this.queue.put(new Hook(loader, classname, body));
    }

    public void add(Runnable r) {
        this.queue.put(r);
    }

    public void add(LeakErrorData m) {
        this.queue.put(m);
    }

    public void run() {
        while (true) {
            Object m = this.queue.get();
            try {
                if (m instanceof Hook) {
                    this.hooking((Hook)m);
                    continue;
                }
                if (m instanceof LeakErrorData) {
                    this.alert((LeakErrorData)m);
                    continue;
                }
                if (!(m instanceof Runnable)) continue;
                this.process((Runnable)m);
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void alert(LeakErrorData d) {
        StatError.getInstance().addError(d);
    }

    private void process(Runnable m) {
        m.run();
    }

    private void hooking(Hook m) {
        if (SystemUtil.IS_AIX && SystemUtil.IS_JAVA_1_5) {
            return;
        }
        if (!AgentBoot.can_redefine) {
            return;
        }
        try {
            Class<?> cls = Class.forName(m.classname, false, m.loader);
            ClassDefinition[] cd = new ClassDefinition[]{new ClassDefinition(cls, m.body)};
            JavaAgent.instrumentation.redefineClasses(cd);
        }
        catch (Throwable t) {
            Logger.println("A160", 10, "async hook fail:" + m.classname + " " + t);
        }
    }

    private static class Hook {
        ClassLoader loader;
        String classname;
        byte[] body;

        public Hook(ClassLoader loader, String classname, byte[] body) {
            this.loader = loader;
            this.classname = classname.replace('/', '.');
            this.body = body;
        }
    }
}

