/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.pstmt;

import whatap.agent.Configure;
import whatap.agent.trace.pstmt.Accessor;
import whatap.agent.trace.pstmt.MariaDB_MariaDbClientPreparedStatement;
import whatap.agent.trace.pstmt.MariaDB_MariaDbServerPreparedStatement;
import whatap.agent.trace.pstmt.MySql_JDBC42PreparedStatement;
import whatap.agent.trace.pstmt.MySql_JDBC4PreparedStatement;
import whatap.agent.trace.pstmt.Oracle_T4CPreparedStatement;
import whatap.lang.conf.ConfObserver;
import whatap.util.IntKeyLinkedMap;
import whatap.util.StringKeyLinkedMap;

public class ReflectPstmtProxy {
    private static IntKeyLinkedMap<String> sqlMap = new IntKeyLinkedMap(1001, 0.9f);
    private static StringKeyLinkedMap<Accessor> handler = new StringKeyLinkedMap(107, 1.0f);

    private static void add(Accessor a) {
        handler.put(a.name(), a);
    }

    public static String getSql(Object o) {
        Accessor acc = handler.get(o.getClass().getName());
        if (acc == null) {
            return null;
        }
        int id = System.identityHashCode(o);
        String sql = sqlMap.get(id);
        if (sql != null) {
            return sql;
        }
        sql = acc.getSql(o);
        if (sql != null) {
            sqlMap.put(id, sql);
        }
        return sql;
    }

    static {
        ReflectPstmtProxy.add(new MySql_JDBC4PreparedStatement());
        ReflectPstmtProxy.add(new MySql_JDBC42PreparedStatement());
        ReflectPstmtProxy.add(new MariaDB_MariaDbClientPreparedStatement());
        ReflectPstmtProxy.add(new MariaDB_MariaDbServerPreparedStatement());
        ReflectPstmtProxy.add(new Oracle_T4CPreparedStatement());
        ConfObserver.add("ReflectPstmtProxy", new Runnable(){

            public void run() {
                sqlMap.setMax(Configure.getInstance().cache_pstmt_size);
            }
        });
        sqlMap.setMax(Configure.getInstance().cache_pstmt_size);
    }
}

