/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.plugin.PluginHttpCallEnd;
import whatap.agent.proxy.IHttpClient;
import whatap.agent.proxy.NettyHttpClientFactory;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.httpc.HttpcTraceHelper;
import whatap.agent.trace.httpc.urlnorm.HttpcUrlNorm;
import whatap.lang.step.HttpcStepX;
import whatap.util.CastUtil;
import whatap.util.IntKeyLinkedMap;

public class ForRibbonLB
implements HttpcTraceHelper.IHelper {
    private boolean ok = true;
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(5);
    Configure conf = Configure.getInstance();

    public boolean start(TraceContext ctx, HttpcStepX step, HookArgs hookPoint) {
        step.driver = "Ribbon";
        if (this.ok && hookPoint.args != null && hookPoint.args.length > 2) {
            try {
                IHttpClient httpclient = this.getProxy(hookPoint);
                String host = httpclient.getHost(hookPoint.args[0]);
                if (host != null) {
                    int x = host.indexOf(58);
                    if (x >= 0) {
                        ctx.httpc_host = host.substring(0, x);
                        ctx.httpc_port = CastUtil.cint(host.substring(x + 1));
                    } else {
                        ctx.httpc_host = host;
                    }
                }
                ctx.httpc_url = httpclient.getURI(hookPoint.args[1]);
                ctx.httpc_url = this.fw_stripes(ctx.httpc_url);
                ctx.httpc_url = ConfTrace.trace_origin_httpc_enabled ? HttpcUrlNorm.normalize(ctx.httpc_url, step) : HttpcUrlNorm.normalize(ctx.httpc_url);
                this.transfer(httpclient, ctx, step, hookPoint.args[1]);
            }
            catch (Throwable e) {
                ctx.httpc_url = e.toString();
                e.printStackTrace();
                this.ok = false;
            }
        }
        if (ctx.httpc_url == null) {
            ctx.httpc_url = hookPoint.class1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(HookArgs hookPoint) {
        int key = System.identityHashCode(hookPoint.this1.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForRibbonLB forRibbonLB = this;
            synchronized (forRibbonLB) {
                httpclient = NettyHttpClientFactory.create(hookPoint.this1.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }

    private void transfer(IHttpClient httpclient, TraceContext ctx, HttpcStepX step, Object req) {
        try {
            if (ConfMTrace.mtrace_enabled) {
                httpclient.addHeader(req, ConfMTrace._trace_mtrace_poid_key, TraceContext.transferPOID());
                if (ConfMTrace.stat_mtrace_enabled) {
                    httpclient.addHeader(req, ConfMTrace._trace_mtrace_spec_key1, ctx.transferSPEC_URL1());
                }
                if (ConfMTrace.mtid_mtrace_enabled && ctx.mtid != 0L) {
                    httpclient.addHeader(req, ConfMTrace._trace_mtrace_caller_key, ctx.transferMTID_CALLERTX(step.stepId));
                }
            }
        }
        catch (Throwable e) {
            Logger.println("A134", 10, e);
            this.ok = false;
        }
    }

    private String fw_stripes(String url) {
        if (url == null) {
            return null;
        }
        int y = url.indexOf(63);
        if (y > 0) {
            return url.substring(0, y);
        }
        return url;
    }

    public HttpcTraceHelper.HttpcEndValue end(TraceContext ctx, HookArgs hookPoint, Throwable thr) {
        if (this.ok && hookPoint.returnValue != null) {
            try {
                HttpcTraceHelper.HttpcEndValue httpcEndValue = new HttpcTraceHelper.HttpcEndValue();
                IHttpClient httpclient = this.getProxy(hookPoint);
                httpcEndValue.exception = thr;
                httpcEndValue.status = httpclient.getStatus(hookPoint.returnValue);
                if (httpcEndValue.status >= 400) {
                    httpcEndValue.status_reason = httpclient.getStatusReason(hookPoint.returnValue);
                }
                PluginHttpCallEnd.process(ctx, httpcEndValue);
                return httpcEndValue;
            }
            catch (Throwable e) {
                this.ok = false;
                Logger.println("A135", 10, e);
            }
        }
        return null;
    }
}

