/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import javax.sql.DataSource;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.api.trace.TxTraceBackground;
import whatap.agent.conf.ConfHook;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.MeterUsers;
import whatap.agent.data.DataTextAgent;
import whatap.agent.plugin.PluginTraceHelperEnd;
import whatap.agent.plugin.PluginTraceHelperStart;
import whatap.agent.proxy.HttpCtx;
import whatap.agent.proxy.HttpTraceFactory;
import whatap.agent.proxy.IHttpTrace;
import whatap.agent.trace.AutoServiceStartAnalyzer;
import whatap.agent.trace.BuildPos;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.HookReturn;
import whatap.agent.trace.LoadedContext;
import whatap.agent.trace.LocalContext;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MethodStepX;
import whatap.util.AnsiPrint;
import whatap.util.CastUtil;
import whatap.util.HashUtil;
import whatap.util.ObjectUtil;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class TraceMain {
    private static IHttpTrace http = null;
    static long last_log;
    private static Object lock;
    private static Configure conf;

    public static Object startHttpService(Object req, Object res) {
        try {
            return TraceMain.startHttp(req, res);
        }
        catch (Throwable t) {
            Logger.println("A118", 10, "fail to deploy ", t);
            return null;
        }
    }

    public static Object startHttpFilter(Object req, Object res) {
        try {
            return TraceMain.startHttp(req, res);
        }
        catch (Throwable t) {
            Logger.println("A119", 10, "fail to deploy ", t);
            return null;
        }
    }

    public static Object reject(Object ctx) {
        return TxTrace.reject((TraceContext)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object startHttp(Object req, Object res) {
        HttpCtx hc;
        if (!ConfTrace.trace_javax_servlet_enabled) {
            return null;
        }
        if (http == null) {
            Object object = lock;
            synchronized (object) {
                if (http == null) {
                    http = HttpTraceFactory.create(req.getClass().getClassLoader());
                }
            }
        }
        if ((hc = http.wrap(req, res)) != null) {
            return TxTrace.startHttpTx(hc.request, hc.response);
        }
        return null;
    }

    public static void endHttpService(Object stat, Throwable thro) {
        try {
            TxTrace.endHttpTx((TraceContext)stat, thro);
        }
        catch (Throwable t) {
            Logger.println("TraceMain", 10, "endHttpService", t);
        }
    }

    public static Object startService(String name, String className, String methodName, String methodDesc, Object _this, Object[] arg) {
        return TxTrace.startTx(name, className, methodName, methodDesc, _this, arg);
    }

    public static void endService(Object stat, Object returnValue1, Throwable th) {
        try {
            TxTrace.endTx((TraceContext)stat, returnValue1, th);
        }
        catch (Throwable t) {
            Logger.println("TraceMain", 10, "endService", t);
        }
    }

    public static Object startServiceBackground(String name, String className, String methodName, String methodDesc, Object _this, Object[] arg) {
        return TxTraceBackground.startTx(name, className, methodName, methodDesc, _this, arg);
    }

    public static void endServiceBackground(Object stat, Object returnValue1, Throwable th) {
        try {
            TxTraceBackground.endTx((TraceContext)stat, returnValue1, th);
        }
        catch (Throwable t) {
            Logger.println("TraceMain", 10, "endServiceBackground", t);
        }
    }

    public static Object startMethod(int hash, String classMethod) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            if (TraceMain.conf.trace_auto_transaction_enabled) {
                ctx = (TraceContext)TraceMain.startService(classMethod, "none", "none", "none", null, null);
                if (ctx != null && TraceMain.conf.trace_auto_transaction_backstack_enabled) {
                    String stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2);
                    AutoServiceStartAnalyzer.put(classMethod, stack);
                    MessageStep m = new MessageStep();
                    m.hash = HashUtil.hash("TRANSACTION BACKSTACK");
                    DataTextAgent.MESSAGE.add(m.hash, "TRANSACTION BACKSTACK");
                    m.desc = stack;
                    ctx.profile.add(m);
                }
                LocalContext lctx = new LocalContext(ctx, null);
                lctx.service = true;
                return lctx;
            }
            return null;
        }
        DataTextAgent.METHOD.add(hash, classMethod);
        MethodStepX p = new MethodStepX();
        p.start_time = ctx.getElapsedTime();
        p.hash = hash;
        if (ConfTrace.trace_method_resource_enabled) {
            p.start_cpu = (int)(SysJMX.getThreadCPU(ctx.thread.getId()) - ctx.start_cpu);
            if (TraceMain.conf.trace_malloc_step_enabled) {
                p.start_mem = (int)(SysJMX.getThreadAllocBytes(ctx.thread.getId()) - ctx.start_malloc);
            }
        }
        if (ConfTrace._trace_position_method_hash != 0) {
            BuildPos.profileMethodPos(p, classMethod);
        }
        ctx.profile.push(p);
        return new LocalContext(ctx, p);
    }

    public static Object startMethod(TraceContext ctx, int hash, String classMethod) {
        if (ctx == null) {
            return null;
        }
        DataTextAgent.METHOD.add(hash, classMethod);
        MethodStepX p = new MethodStepX();
        p.start_time = ctx.getElapsedTime();
        p.hash = hash;
        ctx.profile.push(p);
        return new LocalContext(ctx, p);
    }

    public static void endMethod(Object localContext, Throwable thr) {
        if (localContext == null) {
            return;
        }
        LocalContext lctx = (LocalContext)localContext;
        if (lctx.service) {
            TraceMain.endService(lctx.context, null, thr);
            return;
        }
        MethodStepX step = (MethodStepX)lctx.step;
        if (step == null) {
            return;
        }
        TraceContext ctx = lctx.context;
        if (ctx == null) {
            return;
        }
        step.elapsed = ctx.getElapsedTime() - step.start_time;
        ++ctx.method_count;
        ctx.method_time += step.elapsed;
        ctx.handleMethodErrorStack(thr);
        ctx.profile.pop(step);
    }

    public static void methodError(String classMethod, Throwable thr) {
        if (thr == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        ctx.handleMethodErrorStack(thr);
    }

    public static void setServiceName(String name) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null || name == null) {
            return;
        }
        ctx.service_name = name;
        ctx.service_hash = HashUtil.hash(name);
    }

    public static void ctxLookup(Object this1, Object ctx) {
        if (ctx instanceof DataSource) {
            LoadedContext.put((DataSource)ctx);
        }
    }

    public static void jspServlet(Object[] arg) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null || arg.length < 3) {
            return;
        }
        MessageStep step = new MessageStep();
        step.start_time = ctx.getElapsedTime();
        step.hash = HashUtil.hash("JSP");
        DataTextAgent.MESSAGE.add(step.hash, "JSP");
        step.desc = CastUtil.cString(arg[2]);
        ctx.profile.add(step);
    }

    public static void traceHelperStart(String className, String methodName, String methodDesc, Object this1, Object[] arg) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        PluginTraceHelperStart.process(ctx, new HookArgs(className, methodName, methodDesc, this1, arg));
    }

    public static void traceHelperEnd(String className, String methodName, String methodDesc, Object this1, Object rtn) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        PluginTraceHelperEnd.process(ctx, new HookReturn(className, methodName, methodDesc, this1, rtn));
    }

    public static void exception(Throwable t) {
        if (t == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (!ctx.isStaticContents) {
            ctx.handleEndTxErrorStack(t);
        }
    }

    public static void create_exception(Object o) {
        if (ConfTrace.trace_create_exception_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (!ctx.hasErrorStack && o instanceof Throwable) {
                ctx.hasErrorStack = true;
                Throwable t = (Throwable)o;
                if (ConfTrace.trace_create_exception_stack) {
                    ctx.profile(t, ConfTrace.trace_create_exception_depth);
                }
                if (ctx.exception == null) {
                    ctx.exception = t;
                }
            }
        }
    }

    public static void capArgs(String className, String methodName, String methodDesc, Object this1, Object[] arg) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        String title = "[TraceArg] " + className + "#" + methodName;
        int titleHash = HashUtil.hash(title);
        DataTextAgent.MESSAGE.add(titleHash, title);
        try {
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = titleHash;
            step.desc = TraceMain.toString(arg);
            ctx.profile.add(step);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void capReturn(String className, String methodName, String methodDesc, Object this1, Object rtn) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        String title = "[TraceReturn] " + className + "#" + methodName;
        int titleHash = HashUtil.hash(title);
        DataTextAgent.MESSAGE.add(titleHash, title);
        try {
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = titleHash;
            step.desc = TraceMain.toStringRTN(rtn);
            ctx.profile.add(step);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void capReturnUser(String className, String methodName, String methodDesc, Object this1, Object rtnUser) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (ConfTrace.trace_cap_return_user_enabled) {
            String title = "[TraceUser] " + className + "#" + methodName;
            int titleHash = HashUtil.hash(title);
            DataTextAgent.MESSAGE.add(titleHash, title);
            try {
                MessageStep step = new MessageStep();
                step.start_time = ctx.getElapsedTime();
                step.hash = titleHash;
                step.desc = TraceMain.toStringRTN(rtnUser);
                ctx.profile.add(step);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (rtnUser != null) {
                ctx.wclientId = HashUtil.hash64(rtnUser.toString());
                MeterUsers.add(ctx.wclientId);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void capThis(String className, String methodDesc, Object this0) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        String title = "[TraceThis] " + className;
        int titleHash = HashUtil.hash(title);
        DataTextAgent.MESSAGE.add(titleHash, title);
        try {
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = titleHash;
            step.desc = TraceMain.toStringTHIS(this0);
            ctx.profile.add(step);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String toString(Object[] arg) {
        StringBuilder sb = new StringBuilder();
        int max = arg.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            TraceMain.append(sb, arg[i]);
        }
        return sb.toString();
    }

    private static void append(StringBuilder sb, Object o) {
        if (o == null || o instanceof Number) {
            sb.append(o);
        } else {
            String s = o.toString();
            if (TraceMain.conf.cap_string_cut_first_length > 0 && s.length() > 0 && s.length() > TraceMain.conf.cap_string_cut_first_length) {
                s = s.substring(TraceMain.conf.cap_string_cut_first_length);
            }
            if (TraceMain.conf.cap_string_length > 0 && s.length() > TraceMain.conf.cap_string_length) {
                sb.append("'").append(TraceMain.erase_ansi(s.substring(0, TraceMain.conf.cap_string_length))).append(" ...'");
            } else {
                sb.append("'").append(TraceMain.erase_ansi(s)).append("'");
            }
        }
    }

    private static String erase_ansi(String s) {
        if (TraceMain.conf.cap_erase_ansi_enabled) {
            return AnsiPrint.erase(s);
        }
        return s;
    }

    private static String toStringRTN(Object rtn) {
        StringBuilder sb = new StringBuilder();
        TraceMain.append(sb, rtn);
        return sb.toString();
    }

    private static String toStringTHIS(Object arg) {
        StringBuffer sb = new StringBuffer();
        String arstr = StringUtil.limiting(ObjectUtil.toString(arg), TraceMain.conf.cap_string_length);
        sb.append(arstr);
        return sb.toString();
    }

    public static void log(String fullname) {
        Logger.println("MLOG", fullname);
    }

    public static void startName(String className, String method, String firstString) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            switch (ConfHook.hook_tx_name_mode) {
                case 0: {
                    ctx.service_name = TraceMain.plus(ctx.service_name, className);
                    ctx.service_hash = HashUtil.hash(ctx.service_name);
                    break;
                }
                case 1: {
                    ctx.service_name = TraceMain.plus(ctx.service_name, method);
                    ctx.service_hash = HashUtil.hash(ctx.service_name);
                    break;
                }
                case 2: {
                    if (firstString == null || firstString.length() <= 0) break;
                    ctx.service_name = TraceMain.plus(ctx.service_name, StringUtil.truncate(firstString, 128));
                    ctx.service_hash = HashUtil.hash(ctx.service_name);
                }
            }
        }
    }

    private static String plus(String service_name, String append) {
        StringBuilder sb = new StringBuilder(service_name.length() + append.length() + 16);
        sb.append(service_name).append('+').append(append);
        return sb.toString();
    }

    public static void endName(Object returnValue) {
        TraceContext ctx;
        if (returnValue != null && ConfHook.hook_tx_name_mode >= 10 && (ctx = TraceContextManager.getLocalContext()) != null) {
            ctx.service_name = TraceMain.plus(ctx.service_name, StringUtil.truncate(returnValue.toString(), 128));
            ctx.service_hash = HashUtil.hash(ctx.service_name);
        }
    }

    public static void gtidArgs(String className, String method, String firstString) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (firstString != null && firstString.length() > 0) {
            if (ctx.mtid == 0L) {
                ctx.customTrace(firstString);
            } else {
                ctx.custid = firstString;
            }
        }
    }

    public static void gtidReturn(Object returnValue) {
        TraceContext ctx;
        if (returnValue != null && (ctx = TraceContextManager.getLocalContext()) != null) {
            if (ctx.mtid == 0L) {
                ctx.customTrace(StringUtil.truncate(returnValue.toString(), 128));
            } else {
                ctx.custid = StringUtil.truncate(returnValue.toString(), 128);
            }
        }
    }

    public static void login(Object rtn) {
        if (rtn == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        ctx.login = rtn.toString();
    }

    static {
        lock = new Object();
        conf = Configure.getInstance();
    }
}

