/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.step.MessageStep;
import whatap.util.HashUtil;

public class TraceFutureTask {
    public static String CTX_FIELD = "_whatap_ctx_";
    private static int THREAD_START;

    public static TraceContext getContext() {
        return TraceContextManager.getLocalContext();
    }

    public static void attach(TraceContext ctx) {
        TraceContextManager.attach(ctx);
    }

    public static void startThread(Thread thread) {
        if (!ConfTrace.trace_thread_start_enabled) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (THREAD_START == 0) {
            THREAD_START = HashUtil.hash("Thread-Start");
            DataTextAgent.MESSAGE.add(THREAD_START, "Thread-Start");
        }
        try {
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = THREAD_START;
            step.desc = thread.getName();
            ctx.profile.add(step);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

