/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.Logger;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.step.MessageStep;
import whatap.util.HashUtil;
import whatap.util.ThreadUtil;

public class TraceDebug {
    public static Object start(String className, String methodName, String methodDesc, Object _this, Object[] arg) {
        StringBuffer sb = new StringBuffer();
        sb.append("class=").append(className);
        sb.append("\nmethod=").append(methodName).append(methodDesc);
        if (_this != null) {
            sb.append("\nthis=").append(_this.getClass().getName());
        }
        if (arg != null && arg.length > 0) {
            sb.append("\narg=");
            for (int i = 0; i < arg.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(arg[i].getClass().getName());
            }
        }
        sb.append("\nstack=").append(ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2, ". "));
        return sb;
    }

    public static void end(Object stat, Object rtn, Throwable th) {
        TraceContext ctx;
        if (stat == null) {
            return;
        }
        StringBuffer sb = (StringBuffer)stat;
        if (rtn != null) {
            sb.append("\nreturn=").append(rtn.getClass().getName());
        }
        if (th != null) {
            sb.append("\nexception=").append(th.getClass().getName()).append(" ").append(th.getMessage());
            sb.append("::: ").append(ThreadUtil.getStackTrace(th.getStackTrace(), 2, ". "));
        }
        if ((ctx = TraceContextManager.getLocalContext()) != null) {
            MessageStep m = new MessageStep();
            m.hash = HashUtil.hash("Debug-Method");
            DataTextAgent.MESSAGE.add(m.hash, "Debug-Method");
            m.desc = sb.toString();
            ctx.profile.add(m);
        }
        Logger.println("DEBUG", sb.toString());
    }
}

