/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import whatap.agent.Configure;
import whatap.agent.Ref;
import whatap.agent.api.trace.Request;
import whatap.agent.api.trace.Response;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.task.AgentInfo;
import whatap.agent.data.DataTextAgent;
import whatap.agent.stat.ErrorArg;
import whatap.agent.trace.FakeCollector;
import whatap.agent.trace.HttpLog;
import whatap.agent.trace.IProfileCollector;
import whatap.agent.trace.ProfileCircularCollector;
import whatap.agent.trace.ProfileLargeCollector;
import whatap.agent.trace.ProfileNormalCollector;
import whatap.agent.trace.ProfileSplitTxCollector;
import whatap.agent.trace.SqlParameter;
import whatap.agent.trace.sql.SID;
import whatap.lang.PKOID;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MessageStepX;
import whatap.lang.step.MethodStepX;
import whatap.lang.step.SqlStepX;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.Hexa32;
import whatap.util.IntKeyMap;
import whatap.util.KeyGen;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class TraceContext {
    public boolean isStaticContents;
    public boolean closed = false;
    public boolean skipThreadLocal = false;
    public long mtid;
    public int mdepth;
    public String custid;
    public String mcallerTraceparentValue;
    public long mcaller_txid;
    public long mcaller_pcode;
    public int mcaller_okind;
    public int mcaller_oid;
    public String mcaller_spec;
    public int mcaller_url_hash;
    public long mcaller_stepId;
    public Thread thread;
    public long threadId;
    public long txid;
    public long tx_threading_id;
    public IProfileCollector profile;
    public long start_cpu;
    public long start_cpu2;
    public long start_malloc;
    public long start_malloc2;
    public long start_time;
    public int parentOffsetTime;
    public int status;
    public int service_hash;
    public boolean serviceNew;
    public String service_name;
    public String origin_url;
    public int remoteIp;
    public String remoteAddr;
    public boolean remoteAddrIPv6;
    public StringBuffer http_url;
    public String http_method;
    public String http_query;
    public String http_content_type;
    public String http_host;
    public int http_host_hash;
    public int sql_count;
    public int sql_time;
    public int method_count;
    public int method_time;
    public int dbc_time;
    public int executed_dbc;
    public int executed_sqlhash;
    public SqlStepX sql;
    public String sqlText;
    public int httpc_count;
    public int httpc_time;
    public String httpc_url;
    public int httpc_stime;
    public int active_httpc_hash;
    public String httpc_host;
    public long httpc_stepId;
    public int httpc_host_hash;
    public int httpc_port;
    public long wclientId;
    public int userAgent;
    public String userAgentString;
    public int referer;
    public String refererString;
    public String login;
    public int customLeak;
    public boolean debug_sql_call;
    public int profileActive;
    public int jdbc_update_record;
    public int jdbc_identity;
    public IntKeyMap<StackTraceElement[]> unclosedConnMap;
    public IntKeyMap<StackTraceElement[]> unclosedStmtMap;
    public int rs_count;
    public long rs_time;
    public boolean db_opening;
    public MapValue fields;
    public Throwable exception;
    public boolean mtid_build_checked;
    public TraceContext parent;
    private String transfer_info = null;
    public int recursive_exec;
    public boolean recursive_alerted;
    public boolean is_async_ctx;
    public boolean socket_connecting;
    public boolean thread_auto_killed;
    public int currentElapsed;
    public MethodStepX childStartStep;
    public int trace_active_transaction_yellow_time;
    public int trace_active_transaction_red_time;
    public ErrorArg error;
    public boolean hasErrorStack;
    public long endTime;
    public int elapsed;
    public HttpLog reqlog;
    public boolean disable_file_trace;
    public String httpc_update_name;
    private boolean isScheduled;
    public boolean isBackground;
    public boolean addActiveTxListEnabled;
    public boolean addActiveTxCounterEnabled;
    public boolean addMeterServiceEnabled;
    public Object option;
    public AtomicInteger asyncCount;
    public AtomicBoolean isSuspended;
    public AtomicBoolean isPreHandled;
    private String tmpTransferMst;
    public boolean jdbc_stmt_loading_sid;
    public SID sid;
    public int dbc_hash;
    public long rs_async_stime;
    public SqlStepX rs_async_sql;
    public boolean async_forward;
    public Request request;
    public Response response;
    public boolean stat_enabled;
    public SqlParameter sqlParam;
    public String appctx;
    public int reactor_exec_count;
    private static String transfer_poid;
    private static StringKeyLinkedMap<PKOID> poids;
    static Configure conf;
    private static final Object lock;
    private static AtomicInteger nextStepId;
    public static final String WTP_TXID = "WTP-TXID";
    public static final String WTP_HEADER_TXID = "x-wtp-txid";
    public static final String WTP_ATTRIBUTE_TXID = "wtp.txid";

    public TraceContext() {
        this.trace_active_transaction_yellow_time = TraceContext.conf.trace_active_transaction_yellow_time;
        this.trace_active_transaction_red_time = TraceContext.conf.trace_active_transaction_red_time;
        this.isScheduled = false;
        this.isBackground = false;
        this.addActiveTxListEnabled = true;
        this.addActiveTxCounterEnabled = true;
        this.addMeterServiceEnabled = true;
        this.asyncCount = new AtomicInteger(0);
        this.isSuspended = new AtomicBoolean(false);
        this.isPreHandled = new AtomicBoolean(false);
        this.stat_enabled = true;
    }

    public static TraceContext sampling() {
        TraceContext ctx = new TraceContext(0);
        ctx.txid = -1L;
        return ctx;
    }

    public TraceContext(int mode) {
        this.trace_active_transaction_yellow_time = TraceContext.conf.trace_active_transaction_yellow_time;
        this.trace_active_transaction_red_time = TraceContext.conf.trace_active_transaction_red_time;
        this.isScheduled = false;
        this.isBackground = false;
        this.addActiveTxListEnabled = true;
        this.addActiveTxCounterEnabled = true;
        this.addMeterServiceEnabled = true;
        this.asyncCount = new AtomicInteger(0);
        this.isSuspended = new AtomicBoolean(false);
        this.isPreHandled = new AtomicBoolean(false);
        this.stat_enabled = true;
        switch (mode) {
            case 0: {
                this.profile = FakeCollector.instance;
                break;
            }
            case 1: {
                this.profile = new ProfileNormalCollector();
                break;
            }
            case 2: {
                this.profile = new ProfileCircularCollector();
                break;
            }
            case 3: {
                this.profile = new ProfileLargeCollector(this);
                break;
            }
            case 4: {
                this.profile = new ProfileSplitTxCollector(this);
                break;
            }
            default: {
                this.profile = new ProfileNormalCollector();
            }
        }
    }

    public void customTrace(String id) {
        if (id != null && id.length() > 0) {
            this.custid = id;
            try {
                this.mtid = Long.parseLong(id);
            }
            catch (NumberFormatException e) {
                this.mtid = ConfTrace.custid_v1_enabled ? HashUtil.oldHash64(id.getBytes()) : HashUtil.hash64(id);
            }
            this.mtid_build_checked = true;
        }
    }

    public void customTraceLong(long id) {
        this.custid = Long.toString(id);
        this.mtid = id;
        this.mtid_build_checked = true;
    }

    public int getElapsedTime() {
        return (int)(DateUtil.nanoToMillis() - this.start_time);
    }

    public void resetStartTime() {
        this.start_time = DateUtil.nanoToMillis();
    }

    public void resetStartTime(int parentOffsetTime) {
        this.parentOffsetTime = parentOffsetTime;
        this.start_time = DateUtil.nanoToMillis();
    }

    public int getElapsedTime(long time) {
        return (int)(time - this.start_time);
    }

    public byte getActiveStatus() {
        if (this.sql != null) {
            return 1;
        }
        if (this.active_httpc_hash != 0) {
            return 2;
        }
        if (this.db_opening) {
            return 3;
        }
        if (this.socket_connecting) {
            return 4;
        }
        return 0;
    }

    public void setExtraField(String key, Value value) {
        if (this.fields == null) {
            this.fields = new MapValue();
        }
        this.fields.put(key, value);
    }

    public Value getExtraField(String key) {
        if (this.fields == null) {
            return null;
        }
        return this.fields.get(key);
    }

    public MapValue extraFields() {
        if (this.fields == null) {
            this.fields = new MapValue();
        }
        return this.fields;
    }

    public String transferMTID_CALLERTX() {
        if (this.tmpTransferMst == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append(Hexa32.toString32(this.mtid));
            sb.append(",");
            sb.append(this.mdepth + 1);
            sb.append(",");
            sb.append(Hexa32.toString32(this.txid));
            this.tmpTransferMst = sb.toString();
        }
        return this.tmpTransferMst;
    }

    public String trasferMTID_TRACEPARENT(long stepid) {
        String traceparent = null;
        if (this.mcallerTraceparentValue != null && this.mcallerTraceparentValue.length() > 0) {
            traceparent = String.format("00-%s-%016x-01", this.mcallerTraceparentValue, stepid);
        } else if (this.mtid != 0L) {
            traceparent = String.format("00-0000000000000000%016x-%016x-01", this.mtid, stepid);
        }
        return traceparent;
    }

    public String transferMTID_CALLERTX(long stepid) {
        StringBuilder sb = new StringBuilder(50);
        if (this.tmpTransferMst == null) {
            sb.append(Hexa32.toString32(this.mtid));
            sb.append(",");
            sb.append(this.mdepth + 1);
            sb.append(",");
            sb.append(Hexa32.toString32(this.txid));
            this.tmpTransferMst = sb.toString();
        } else {
            sb.append(this.tmpTransferMst);
        }
        sb.append(",").append(Hexa32.toString32(stepid));
        return sb.toString();
    }

    public String transferSPEC_URL() {
        if (this.transfer_info != null) {
            return this.transfer_info;
        }
        StringBuffer sb = new StringBuffer(ConfMTrace.mtrace_send_url_length + 40);
        sb.append(ConfMTrace.mtrace_spec);
        sb.append(",");
        if (ConfMTrace.mtrace_send_url_length > 0) {
            sb.append(StringUtil.limiting(this.service_name, ConfMTrace.mtrace_send_url_length));
        } else {
            sb.append(this.service_name);
        }
        this.transfer_info = sb.toString();
        return this.transfer_info;
    }

    public String transferSPEC_URL1() {
        if (this.transfer_info != null) {
            return this.transfer_info;
        }
        StringBuffer sb = new StringBuffer(80);
        sb.append(ConfMTrace.mtrace_spec);
        sb.append(",");
        sb.append(this.service_hash);
        this.transfer_info = sb.toString();
        return this.transfer_info;
    }

    public static String transferPOID() {
        if (transfer_poid != null) {
            return transfer_poid;
        }
        TraceContext.updatePOID();
        return transfer_poid;
    }

    public static void updatePOID() {
        StringBuffer sb = new StringBuffer();
        sb.append(Hexa32.toString32(Configure.PCODE));
        sb.append(",");
        sb.append(Hexa32.toString32(TraceContext.conf.OKIND));
        sb.append(",");
        sb.append(Hexa32.toString32(Configure.OID));
        transfer_poid = sb.toString();
    }

    public void setCallerPOID(String poidStr) {
        try {
            PKOID poid = poids.get(poidStr);
            if (poid == null) {
                int x = poidStr.indexOf(44);
                String s1 = poidStr.substring(0, x);
                long pcode = s1.length() == 0 ? 0L : Hexa32.toLong32(s1);
                int y = poidStr.indexOf(44, x + 1);
                s1 = poidStr.substring(x + 1, y);
                int okind = s1.length() == 0 ? 0 : (int)Hexa32.toLong32(s1);
                s1 = poidStr.substring(y + 1);
                int oid = s1.length() == 0 ? 0 : (int)Hexa32.toLong32(s1);
                poid = new PKOID(pcode, okind, oid);
                poids.put(poidStr, poid);
            }
            this.mcaller_pcode = poid.pcode;
            this.mcaller_okind = poid.okind;
            this.mcaller_oid = poid.oid;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setTransferMTID_CALLERTX(String headerString) {
        try {
            int x = headerString.indexOf(44);
            if (x > 0) {
                this.mtid = Hexa32.toLong32(headerString.substring(0, x));
                this.mtid_build_checked = true;
                int y = headerString.indexOf(44, x + 1);
                if (y > 0) {
                    this.mdepth = Integer.parseInt(headerString.substring(x + 1, y));
                    int z = headerString.indexOf(44, y + 1);
                    if (z < 0) {
                        this.mcaller_txid = Hexa32.toLong32(headerString.substring(y + 1));
                    } else {
                        this.mcaller_txid = Hexa32.toLong32(headerString.substring(y + 1, z));
                        int z2 = headerString.indexOf(44, z + 1);
                        this.mcaller_stepId = z2 < 0 ? Hexa32.toLong32(headerString.substring(z + 1)) : Hexa32.toLong32(headerString.substring(z + 1, z2));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setTransferSPEC_URL1(String headerString) {
        try {
            int y = headerString.indexOf(44);
            this.mcaller_spec = headerString.substring(0, y);
            this.mcaller_url_hash = CastUtil.cint(headerString.substring(y + 1));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setTxid(String myid) {
        try {
            this.txid = Hexa32.toLong32(myid);
        }
        catch (Throwable e) {
            this.txid = KeyGen.next();
        }
    }

    public void profile(Throwable thro) {
        this.profile(thro, ConfTrace.trace_exception_depth);
    }

    public void profile(Throwable thro, int depth) {
        if (thro == null) {
            return;
        }
        int titleHash = HashUtil.hash("Error Stack");
        DataTextAgent.MESSAGE.add(titleHash, "Error Stack");
        StackTraceElement[] se = thro.getStackTrace();
        StringBuilder sb = new StringBuilder(512);
        sb.append(thro.toString()).append("\n");
        if (se.length > 0) {
            sb.append(se[0]);
            for (int i = 1; i < se.length && i < depth; ++i) {
                sb.append("\n").append(se[i]);
            }
        }
        if (!ConfTrace.trace_point_step_message_enabled) {
            MessageStep m = new MessageStep();
            m.start_time = this.getElapsedTime();
            m.hash = titleHash;
            m.desc = sb.toString();
            this.profile.add(m);
        } else {
            MessageStepX m = new MessageStepX();
            m.title = "Error Stack";
            m.start_time = this.getElapsedTime();
            m.desc = sb.toString();
            long stepId = KeyGen.next();
            m.setAttr("stepId", new DecimalValue(stepId));
            m.setAttr("type", new TextValue("error_stack"));
            this.profile.add(m);
        }
    }

    public void profile(ErrorArg arg) {
        if (ConfTrace.trace_error_step_enabled) {
            int exception_hash = HashUtil.hash("EXCEPTION");
            DataTextAgent.MESSAGE.add(exception_hash, "EXCEPTION");
            if (!ConfTrace.trace_point_step_message_enabled) {
                MessageStep m = new MessageStep();
                m.start_time = this.getElapsedTime();
                m.hash = exception_hash;
                m.desc = arg.message;
                this.profile.add(m);
            } else {
                MessageStepX m = new MessageStepX();
                m.title = "EXCEPTION";
                m.start_time = this.getElapsedTime();
                m.desc = arg.message;
                long stepId = KeyGen.next();
                m.setAttr("stepId", new DecimalValue(stepId));
                m.setAttr("type", new TextValue("error"));
                this.profile.add(m);
            }
        }
    }

    public void handleMethodErrorStack(Throwable thro) {
        if (thro == null) {
            return;
        }
        if (ConfTrace.trace_component_error_stack) {
            this.handleErrorStack(thro, ConfTrace.trace_method_error_depth);
        }
        if (this.exception == null) {
            this.exception = thro;
        }
    }

    public void handleSqlErrorStack(Throwable thro) {
        if (thro == null) {
            return;
        }
        if (ConfTrace.trace_sql_error_stack) {
            this.handleErrorStack(thro, ConfTrace.trace_sql_error_depth);
        }
    }

    public void handleHttpcErrorStack(Throwable thro) {
        if (thro == null) {
            return;
        }
        if (ConfTrace.trace_httpc_error_stack) {
            this.handleErrorStack(thro, ConfTrace.trace_httpc_error_depth);
        }
    }

    public void handleSocketErrorStack(Throwable thro) {
        if (thro == null) {
            return;
        }
        if (ConfTrace.trace_socket_error_stack) {
            this.handleErrorStack(thro, ConfTrace.trace_socket_error_depth);
        }
    }

    public void handleEndTxErrorStack(Throwable thro) {
        if (thro == null) {
            return;
        }
        if (thro instanceof OutOfMemoryError) {
            AgentInfo.oom_thread = this.thread.getName();
            AgentInfo.oom_message = thro.getMessage();
        }
        if (ConfTrace.trace_endtx_error_stack) {
            this.handleErrorStack(thro, ConfTrace.trace_endtx_error_depth);
        }
        if (this.exception == null) {
            this.exception = thro;
        } else if (ConfTrace.trace_exception_handler_overwrite_enabled) {
            this.exception = thro;
        }
    }

    private void handleErrorStack(Throwable thro, int depth) {
        if (this.hasErrorStack && !ConfTrace.trace_exception_stack_overwrite_enabled) {
            return;
        }
        this.profile(thro, depth);
        this.hasErrorStack = true;
    }

    public String x_wtap_mst() {
        return this.transferMTID_CALLERTX(0L);
    }

    public void x_wtap_mst(String headerString) {
        this.setTransferMTID_CALLERTX(headerString);
    }

    public String x_wtap_sp1() {
        return this.transferSPEC_URL1();
    }

    public void x_wtap_sp1(String headerString) {
        this.setTransferSPEC_URL1(headerString);
    }

    public String x_wtap_po() {
        return TraceContext.transferPOID();
    }

    public void x_wtap_po(String poidStr) {
        this.setCallerPOID(poidStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextCallerStepId() {
        int v = nextStepId.getAndIncrement();
        if (v >= Short.MAX_VALUE) {
            Object object = lock;
            synchronized (object) {
                if (nextStepId.get() >= Short.MAX_VALUE) {
                    nextStepId.set(1);
                }
            }
            v = nextStepId.getAndIncrement();
        }
        return v;
    }

    public void reset() {
        this.closed = true;
        this.profile = FakeCollector.instance;
        this.thread = Ref.dummy;
        this.request = null;
        this.response = null;
    }

    public static boolean isNullOrClosed(TraceContext ctx) {
        return ctx == null || ctx.closed;
    }

    public boolean isFake() {
        return this.txid == -1L;
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    public void setIsScheduled(boolean isScheduled) {
        this.isScheduled = isScheduled;
    }

    public static void asyncForward(TraceContext ctx) {
        if (ctx != null) {
            ctx.async_forward = true;
        }
    }

    public void asyncForward() {
        this.async_forward = true;
    }

    public void closeAsyncForward() {
        this.async_forward = false;
    }

    public boolean isAsyncForwarded() {
        return this.async_forward;
    }

    public void suspendTraceContext(TraceContext ctx) {
        if (ctx != null) {
            ctx.isSuspended.set(true);
        }
    }

    public void suspendTraceContext() {
        this.isSuspended.set(true);
    }

    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    public boolean isPreHandled() {
        return this.isPreHandled.get();
    }

    public void preHandled() {
        this.isPreHandled.set(true);
    }

    public void preHandled(TraceContext ctx) {
        if (ctx != null) {
            ctx.isPreHandled.set(true);
        }
    }

    public int getAsyncCount() {
        return this.asyncCount.get();
    }

    public int getAsyncCount(TraceContext ctx) {
        if (ctx != null) {
            return ctx.asyncCount.get();
        }
        return 0;
    }

    public void incrementAsyncCount() {
        this.asyncCount.getAndIncrement();
    }

    public void incrementAsyncCount(TraceContext ctx) {
        if (ctx != null) {
            ctx.asyncCount.getAndIncrement();
        }
    }

    public void decrementAsyncCount() {
        this.asyncCount.getAndDecrement();
    }

    public void decrementAsyncCount(TraceContext ctx) {
        if (ctx != null) {
            ctx.asyncCount.getAndDecrement();
        }
    }

    public void setAsyncCount() {
        this.asyncCount.set(0);
    }

    public void setAsyncCount(TraceContext ctx) {
        if (ctx != null) {
            ctx.asyncCount.set(0);
        }
    }

    public void close() {
        this.closed = true;
    }

    public void activate(long txid, Request request, Response response) {
        this.txid = txid;
        this.request = request;
        this.response = response;
        this.request.setAttribute(WTP_TXID, txid);
    }

    public static boolean isActivated(TraceContext ctx) {
        if (ctx == null) {
            return false;
        }
        return !ctx.closed;
    }

    public static long getTxid(Request request) {
        if (request == null) {
            return 0L;
        }
        Long txid = (Long)request.getAttribute(WTP_TXID);
        return txid == null ? 0L : txid;
    }

    public static boolean isActivated(Request request) {
        if (request == null) {
            return false;
        }
        if (request.getAttribute(WTP_TXID) != null) {
            return true;
        }
        if (request.getHeader(WTP_HEADER_TXID) != null) {
            return true;
        }
        return request.getAttribute(WTP_ATTRIBUTE_TXID) != null;
    }

    static {
        poids = new StringKeyLinkedMap().setMax(100);
        conf = Configure.getInstance();
        lock = new Object();
        nextStepId = new AtomicInteger(1);
    }
}

