/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.Configure;

public class SqlParameter {
    private static Configure conf = Configure.getInstance();
    protected int count = 0;
    protected String[] entry;
    protected String sql;

    public SqlParameter() {
        this.entry = new String[SqlParameter.conf.sql_param_max];
    }

    public SqlParameter(String sql) {
        this.entry = new String[SqlParameter.conf.sql_param_max];
        this.setSql(sql);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void put(int x, String value) {
        if (this.entry.length <= x) {
            return;
        }
        this.entry[x] = value;
        if (x >= this.count) {
            this.count = x + 1;
        }
    }

    public String get(int x) {
        if (0 <= x && x < this.count) {
            return this.entry[x];
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < this.count; ++i) {
            if (i > 1) {
                buf.append(",");
            }
            buf.append(this.entry[i]);
        }
        return buf.toString();
    }

    public String toString(String prev) {
        StringBuffer buf = new StringBuffer();
        if (prev != null) {
            buf.append(prev);
            for (int i = 1; i < this.count; ++i) {
                buf.append(",");
                buf.append(this.entry[i]);
            }
        } else {
            for (int i = 1; i < this.count; ++i) {
                if (i > 1) {
                    buf.append(SqlParameter.conf.sql_param_separator);
                }
                buf.append(this.entry[i]);
            }
        }
        return buf.toString();
    }

    public synchronized void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.entry[i] = null;
        }
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }
}

