/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.conf.ConfThrottle;
import whatap.agent.data.DataPackSender;
import whatap.agent.plugin.PluginActionScript;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.pack.EventPack;
import whatap.util.FormatUtil;
import whatap.util.IPUtil;
import whatap.util.StringUtil;

public class Alert {
    static Configure conf = Configure.getInstance();
    static long last_rejected = 0L;
    static String oname = System.getProperty("whatap.oname");
    static long last_recursive = 0L;
    static long last_heap_event;
    static long last_cpu_event;
    static long last_disk_event;
    static long last_auto_thread_kill;
    static int too_many_actx_over_count;
    static long last_too_many_actx_time;
    static int too_many_actx_alert_ignored;
    static long last_oom_event;

    public static void rejected(int hash, String url, int ip) {
        long now = System.currentTimeMillis();
        if (now < last_rejected + ConfThrottle.reject_event_interval) {
            return;
        }
        last_rejected = now;
        EventPack e = new EventPack();
        e.title = "REJECTED_URL";
        e.level = (byte)20;
        StringBuffer sb = new StringBuffer();
        sb.append("Rejected " + url);
        e.message = sb.toString();
        e.attr.put("hash", Integer.toString(hash));
        e.attr.put("url", url);
        e.attr.put("ip", IPUtil.toString(ip));
        DataPackSender.send(e);
    }

    public static void recursive(int hash, String url, int ip, int cnt) {
        long now = System.currentTimeMillis();
        if (now < last_recursive + Alert.conf.recursive_event_interval) {
            return;
        }
        last_recursive = now;
        EventPack e = new EventPack();
        e.title = "TOO_MANY_RECURSIVE_EXEC";
        e.level = (byte)20;
        StringBuffer sb = new StringBuffer();
        sb.append("Too many times, recursive executed: " + url + " #" + cnt);
        e.message = sb.toString();
        e.attr.put("hash", Integer.toString(hash));
        e.attr.put("url", url);
        e.attr.put("ip", IPUtil.toString(ip));
        DataPackSender.send(e);
    }

    public static void heapRate(float used) {
        long now = System.currentTimeMillis();
        if (now < last_heap_event + Alert.conf.heap_event_interval) {
            return;
        }
        last_heap_event = now;
        EventPack e = new EventPack();
        e.title = "HIGH_HEAP_MEM_USAGE";
        e.level = (byte)20;
        e.attr.put("metricThreshold", Integer.toString(Alert.conf.heap_event_percent));
        e.attr.put("metricName", "heap_use");
        e.attr.put("metricValue", FormatUtil.prt2(used));
        String usedRate = FormatUtil.prt2(used);
        e.message = "Too high heap usage " + usedRate + "%";
        DataPackSender.send(e);
        if (StringUtil.isNotEmpty(Alert.conf.heap_event_action)) {
            PluginActionScript.process(Alert.conf.heap_event_action, usedRate);
        }
    }

    public static void cpuRate(float cpu) {
        long now = System.currentTimeMillis();
        if (now < last_cpu_event + ConfSysMon.cpu_event_interval) {
            return;
        }
        last_cpu_event = now;
        EventPack e = new EventPack();
        e.title = "HIGH_CPU_USAGE";
        e.level = (byte)20;
        e.attr.put("metricThreshold", Integer.toString(ConfSysMon.cpu_event_percent));
        e.attr.put("metricName", "cpu");
        e.attr.put("metricValue", FormatUtil.prt2(cpu));
        String cpuStr = FormatUtil.prt2(cpu);
        e.message = "Too high cpu usage " + cpuStr + "%";
        DataPackSender.send(e);
        if (StringUtil.isNotEmpty(ConfSysMon.cpu_event_action)) {
            PluginActionScript.process(ConfSysMon.cpu_event_action, cpuStr);
        }
    }

    public static void diskRate(float disk) {
        long now = System.currentTimeMillis();
        if (now < last_disk_event + ConfSysMon.disk_event_interval) {
            return;
        }
        last_disk_event = now;
        EventPack e = new EventPack();
        e.title = "HIGH_DISK_USAGE";
        e.level = (byte)20;
        e.attr.put("metricThreshold", Integer.toString(ConfSysMon.disk_event_percent));
        e.attr.put("metricName", "disk");
        e.attr.put("metricValue", FormatUtil.prt2(disk));
        String diskStr = FormatUtil.prt2(disk);
        e.message = "Too high disk usage " + diskStr + "%";
        DataPackSender.send(e);
        if (StringUtil.isNotEmpty(ConfSysMon.disk_event_action)) {
            PluginActionScript.process(ConfSysMon.disk_event_action, diskStr);
        }
    }

    public static void autoThreadKill(String service_name, long thrid, String tname, int elapsed, String msg) {
        long now = System.currentTimeMillis();
        if (now < last_auto_thread_kill + (long)Alert.conf.auto_thread_kill_event_interval) {
            return;
        }
        last_auto_thread_kill = now;
        EventPack e = new EventPack();
        e.title = "AUTO_THREAD_KILL";
        e.level = (byte)20;
        e.status = 1;
        e.message = msg;
        DataPackSender.send(e);
    }

    public static void checkTooManyActiveTx(int active_tx_count) {
        if (active_tx_count < Alert.conf.too_many_actx_alert_count) {
            too_many_actx_over_count = 0;
        } else {
            if (++too_many_actx_over_count < Alert.conf.too_many_actx_alert_over_time / 5000) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now < last_too_many_actx_time + (long)Alert.conf.too_many_actx_alert_silent_time) {
                ++too_many_actx_alert_ignored;
                return;
            }
            too_many_actx_over_count = 0;
            last_too_many_actx_time = now;
            try {
                String msg;
                StringBuffer sb = new StringBuffer(4096);
                if (Alert.conf.too_many_actx_alert_msg_url_count > 0) {
                    sb.append("too many active #").append(active_tx_count);
                    Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
                    for (int i = 0; i < Alert.conf.too_many_actx_alert_msg_url_count && en.hasMoreElements(); ++i) {
                        TraceContext ent = en.nextElement();
                        if (ent != null && !ent.closed) {
                            sb.append("\n").append(ent.service_name);
                            continue;
                        }
                        --i;
                    }
                    if (too_many_actx_alert_ignored > 0) {
                        sb.append("ignored: ").append(too_many_actx_alert_ignored).append("\n");
                        too_many_actx_alert_ignored = 0;
                    }
                    msg = sb.toString();
                } else {
                    msg = "too many active #" + active_tx_count;
                }
                EventPack e = new EventPack();
                e.title = "TOO_MANY_ACTIVE_TX";
                e.level = (byte)20;
                e.message = msg;
                DataPackSender.send(e);
            }
            catch (Exception e) {
                Logger.println("ACTX_ALERT", e);
            }
        }
    }

    public static void oom_error(String threadName, String errMessage) {
        long now = System.currentTimeMillis();
        if (now < last_oom_event + ConfSysMon.oom_event_interval) {
            return;
        }
        last_oom_event = now;
        EventPack e = new EventPack();
        e.title = "OUT_OF_MEMORY_ERROR";
        e.level = (byte)30;
        e.attr.put("thread", threadName);
        e.message = errMessage;
        DataPackSender.send(e);
    }
}

