/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.tools;

import java.util.concurrent.TimeUnit;
import whatap.agent.util.OldGcBeanFinder;

public class CircuitBreakHelper {
    public int threshold_heap_free = 20;
    public int threshold_gc_cpu = 10;
    private long lastGcCpuNanoTime = this.getGcCpuNanoTime();
    private long lastNanoTime = System.nanoTime();

    public boolean isHighLoaded() {
        long nowNano = System.nanoTime();
        long elapsedTime = nowNano - this.lastNanoTime;
        long nowGcNanoTime = this.getGcCpuNanoTime();
        if (elapsedTime <= 0L) {
            return false;
        }
        double gcCpuTimePct = (double)((nowGcNanoTime - this.lastGcCpuNanoTime) / elapsedTime) * 100.0;
        this.lastNanoTime = nowNano;
        this.lastGcCpuNanoTime = nowGcNanoTime;
        Runtime rt = Runtime.getRuntime();
        double memFreePct = 100.0 * (double)((rt.maxMemory() - rt.totalMemory() + rt.freeMemory()) / rt.maxMemory());
        return gcCpuTimePct >= (double)this.threshold_gc_cpu && memFreePct <= (double)this.threshold_heap_free;
    }

    private long getGcCpuNanoTime() {
        long gcTime = OldGcBeanFinder.getMXBean().getCollectionTime();
        return TimeUnit.NANOSECONDS.convert(gcTime, TimeUnit.MILLISECONDS);
    }
}

