/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.ArrayList;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.ZipPackThread;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.HttpcRec;
import whatap.lang.pack.StatHttpcPack;
import whatap.util.LinkedMap;

public class StatHttpc {
    private static StatHttpc instance;
    private final int TABLE_MAX_SIZE = 5000;
    private final LinkedMap<HTTPC, HttpcRec> table = new LinkedMap<HTTPC, HttpcRec>(5001, 1.0f){

        @Override
        protected HttpcRec create(HTTPC key) {
            if (this.size() >= 5000) {
                return null;
            }
            HttpcRec rec = new HttpcRec();
            rec.setUrlHostPort(key.url, key.host, key.port);
            rec.service = key.service;
            rec.time_min = Integer.MAX_VALUE;
            return rec;
        }
    }.setMax(5000);
    protected Configure conf = Configure.getInstance();

    public static synchronized StatHttpc getInstance() {
        if (instance == null) {
            instance = new StatHttpc();
        }
        return instance;
    }

    public StatHttpc() {
        this.table.setMax(ConfStat.stat_httpc_max_count);
        ConfObserver.add("StatHttpc", new Runnable(){

            public void run() {
                StatHttpc.this.table.setMax(ConfStat.stat_httpc_max_count);
            }
        });
    }

    protected HttpcRec getHttpc(int url, int host, int port, int service) {
        return this.table.intern(new HTTPC(url, host, port, service));
    }

    public void addHttpcTime(int service, int httpc_url_hash, int httpc_host, int httpc_port, int time, boolean isErr) {
        HttpcRec httpcRec;
        if (httpc_url_hash != 0 && (httpcRec = this.getHttpc(httpc_url_hash, httpc_host, httpc_port, service)) != null) {
            ++httpcRec.count_total;
            httpcRec.time_sum += (long)time;
            httpcRec.time_std += (long)time * (long)time;
            httpcRec.time_max = Math.max(httpcRec.time_max, time);
            httpcRec.time_min = Math.min(httpcRec.time_min, time);
            if (isErr) {
                ++httpcRec.count_error;
            }
            httpcRec.service = service;
        }
    }

    protected void send(long now) {
        if (this.table.size() == 0) {
            return;
        }
        try {
            StatHttpcPack p;
            ArrayList<HttpcRec> out = new ArrayList<HttpcRec>(this.table.size() + 10);
            Enumeration<HttpcRec> en = this.table.values();
            while (en.hasMoreElements()) {
                out.add(en.nextElement());
            }
            this.table.clear();
            if (ConfStat.stat_1m_enabled) {
                p = new StatHttpcPack(2817);
                p.dataStartTime = now - 60000L;
            } else {
                p = new StatHttpcPack();
            }
            p.setRecords(out);
            p.time = now;
            if (ConfStat.stat_zip_enabled) {
                ZipPackThread.getInstance().add(p);
            } else {
                DataPackSender.send(p);
            }
        }
        catch (Exception e) {
            Logger.println("A202", 10, e.toString());
        }
    }

    protected void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }

    private static class HTTPC {
        int url;
        int host;
        int port;
        int service;

        public HTTPC(int url, int host, int port, int service) {
            this.url = url;
            this.host = host;
            this.port = port;
            this.service = service;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.host;
            result = 31 * result + this.port;
            result = 31 * result + this.url;
            result = 31 * result + this.service;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HTTPC other = (HTTPC)obj;
            return this.host == other.host && this.port == other.port && this.url == other.url && this.service == other.service;
        }
    }
}

