/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup.simula;

import java.util.Random;
import whatap.agent.data.DataTextAgent;
import whatap.util.BitUtil;
import whatap.util.HashUtil;
import whatap.util.StringKeyLinkedMap;

public class ErrSimula {
    static StringKeyLinkedMap<String> errorMap = new StringKeyLinkedMap();
    static String[] errClass;
    static int errCount;
    static int n;
    static Random r;

    public static long getError(int oid, String kind, int elapsed) {
        if (kind.equals("\uad50\ud658") && elapsed == 30000) {
            return ErrSimula.doErr("java.sql.SQLException", "SQL operation timed out.");
        }
        if (kind.equals("\uc2dc\uc124") && elapsed == 60000) {
            return ErrSimula.doErr("java.sql.ConnectionTimeoutException", "Connection to the database timed out.");
        }
        if (elapsed <= 30000 && ErrSimula.rand(0, 1000) != 0) {
            return 0L;
        }
        if (ErrSimula.rand(0, 100) != 0) {
            return 0L;
        }
        if (++n >= errCount) {
            n = 0;
        }
        String class1 = errClass[n];
        String msg = errorMap.get(class1);
        return ErrSimula.doErr(class1, msg);
    }

    private static long doErr(String class1, String msg) {
        int classHash = HashUtil.hash(class1);
        int msgHash = HashUtil.hash(msg);
        DataTextAgent.ERROR.add(classHash, class1);
        DataTextAgent.ERROR.add(msgHash, msg);
        return BitUtil.composite(classHash, msgHash);
    }

    static int rand(int min, int max) {
        return r.nextInt(max - min) + min;
    }

    static {
        errorMap.put("java.lang.IllegalArgumentException", "Invalid argument passed to the method.");
        errorMap.put("java.lang.NullPointerException", "Object reference is null.");
        errorMap.put("java.lang.ArrayIndexOutOfBoundsException", "Array index is out of bounds.");
        errorMap.put("java.lang.ClassCastException", "Cannot cast object to specified class.");
        errorMap.put("java.lang.ArithmeticException", "Division by zero is not allowed.");
        errorMap.put("java.lang.NumberFormatException", "Invalid number format encountered.");
        errorMap.put("java.io.FileNotFoundException", "The specified file does not exist.");
        errorMap.put("java.io.IOException", "An error occurred during I/O operation.");
        errorMap.put("java.sql.SQLException", "Database query execution failed.");
        errorMap.put("java.sql.SQLTimeoutException", "SQL operation timed out.");
        errorMap.put("java.lang.NoSuchMethodException", "The specified method does not exist.");
        errorMap.put("java.lang.IllegalStateException", "Object is in an invalid state.");
        errorMap.put("java.lang.SecurityException", "Access to the requested resource is denied.");
        errorMap.put("java.lang.UnsupportedOperationException", "Operation is not supported by this object.");
        errorMap.put("java.lang.IndexOutOfBoundsException", "Index is out of range for the collection.");
        errorMap.put("java.util.ConcurrentModificationException", "Concurrent modification of collection detected.");
        errorMap.put("java.lang.ClassNotFoundException", "The specified class could not be found.");
        errorMap.put("java.lang.InstantiationException", "Cannot instantiate abstract class or interface.");
        errorMap.put("java.lang.InterruptedException", "Thread execution was interrupted.");
        errorMap.put("java.lang.OutOfMemoryError", "Java heap space is exhausted.");
        errorMap.put("java.lang.StackOverflowError", "Stack size exceeded due to recursion.");
        errorMap.put("java.lang.IllegalAccessException", "Cannot access private or protected field.");
        errorMap.put("java.io.EOFException", "End of file reached unexpectedly.");
        errorMap.put("java.net.MalformedURLException", "Invalid URL format provided.");
        errorMap.put("java.net.SocketException", "Error occurred in socket operation.");
        errorMap.put("java.net.UnknownHostException", "The specified host could not be resolved.");
        errorMap.put("java.util.concurrent.TimeoutException", "Operation timed out before completion.");
        errorMap.put("java.sql.ConnectionTimeoutException", "Connection to the database timed out.");
        errorMap.put("com.fasterxml.jackson.core.JsonParseException", "Failed to parse JSON string.");
        errorMap.put("java.lang.RuntimeException", "Unexpected runtime exception occurred.");
        errorMap.put("java.util.NoSuchElementException", "No such element found in the collection.");
        errorMap.put("java.lang.AssertionError", "Assertion failed: expected condition is not met.");
        errClass = errorMap.keyArray();
        errCount = errClass.length;
        n = 0;
        r = new Random();
    }
}

