/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.util.Properties;
import java.util.Random;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.boot.AgentProperty;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.logo.Logo;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.agent.setup.simula.HeapSimula;
import whatap.agent.tools.KubeUtil;
import whatap.lang.pack.AgentPropertyPack;
import whatap.lang.pack.CounterPack1;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.IPUtil;
import whatap.util.JarUtil;
import whatap.util.KeyGen;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class WsPing {
    static long last_sent = 0L;

    public static void main(String[] args) {
        short prodid = (short)CastUtil.cint(System.getProperty("prodid", "101"));
        short sysid = (short)CastUtil.cint(System.getProperty("sysid", "1"));
        String oname = System.getProperty("whatap.name");
        oname = System.getProperty("oname", oname);
        String host_id = System.getProperty("ip", "10.10.1." + (oname.hashCode() & 0xFF));
        System.setProperty("whatap.disabled", "true");
        if (System.getProperty("whatap.home") == null) {
            String home = JarUtil.getJarLocation(WsPing.class);
            System.setProperty("whatap.home", home);
        }
        Configure conf = Configure.getInstance();
        conf.waitForInit();
        Configure.TCP_SESSION_ALLOWED = true;
        SecurityMaster sm = SecurityMaster.getInstance();
        sm.PROD_ID = prodid;
        sm.SYS_ID = sysid;
        sm.init();
        sm.ONAME = oname;
        System.setProperty("whatap.name", oname);
        Logo.print();
        long seed = DateUtil.currentTime() ^ (long)SysJMX.getProcessPID() << 32;
        KeyGen.setSeed(seed);
        TcpRequestMgr.getInstance();
        TcpSession.getInstance().waitForConnection();
        DataTextAgent.getInstance().add((byte)13, sm.OID, sm.ONAME);
        AgentProperty.send();
        int sleepMs = 5000;
        long lastSysTime = System.currentTimeMillis();
        Random rand = new Random();
        while (true) {
            WsPing.sendAgentProperty(host_id);
            WsPing.sleepx(sleepMs / 1000);
            long time = DateUtil.currentTime() / (long)sleepMs * (long)sleepMs;
            CounterPack1 pw = new CounterPack1();
            pw.time = time;
            pw.duration = (int)((DateUtil.systime() - lastSysTime + 499L) / 1000L);
            lastSysTime = DateUtil.systime();
            pw.active_tx_slice = new short[]{(short)rand.nextInt(10), (short)rand.nextInt(10), (short)rand.nextInt(10)};
            pw.active_tx_count = WsPing.sum(pw.active_tx_slice);
            pw.tps = rand.nextInt(10) + 10;
            pw.resp_time = rand.nextInt(100) + 100;
            pw.cpu = rand.nextInt(50) + 10;
            pw.cputime = rand.nextInt(1000) + 10;
            pw.heap_max = pw.heap_tot = HeapSimula.getTot(conf.OKIND_NAME, conf.OKIND);
            pw.heap_use = HeapSimula.getUse(Configure.OID, conf.OKIND_NAME, conf.OKIND, pw.time);
            pw.host_ip = IPUtil.toInt(host_id);
            pw.arrival_rate = pw.tps;
            pw.apdex_satisfied = (int)(pw.tps * 5.0f / 2.0f);
            pw.apdex_tolerated = (int)(pw.tps * 5.0f / 2.0f);
            pw.apdex_total = pw.service_count = (int)(pw.tps * 5.0f);
            pw.cpu_cores = Runtime.getRuntime().availableProcessors();
            System.out.println(DateUtil.timestamp() + " " + oname);
            try {
                TcpRequestMgr.getInstance().logSelf(pw);
                DataPackSender.send(pw);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static int sum(short[] a) {
        return a[0] + a[1] + a[2];
    }

    private static void sleepx(int sec) {
        ThreadUtil.sleep(1000L);
        long now;
        while ((now = DateUtil.currentTime() / 1000L) != now / (long)sec * (long)sec) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    static void sendAgentProperty(String host_ip) {
        long now = System.currentTimeMillis();
        if (now - last_sent < 30000L) {
            return;
        }
        last_sent = now;
        Configure conf = Configure.getInstance();
        if (!conf.agent_property_enabled) {
            return;
        }
        SecurityMaster secu = SecurityMaster.getInstance();
        AgentPropertyPack pack = new AgentPropertyPack();
        Properties prop = System.getProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("tag@")) continue;
            String value = prop.getProperty(key);
            String key2 = key.substring("tag@".length());
            pack.put(key2, value);
        }
        pack.put("oname", secu.ONAME);
        if (conf.OKIND != 0) {
            pack.put("okind", String.valueOf(conf.OKIND));
            pack.put("okind_name", String.valueOf(conf.OKIND_NAME));
        }
        if (conf.ONODE != 0) {
            pack.put("onode", String.valueOf(conf.ONODE));
            pack.put("onode_name", String.valueOf(conf.ONODE_NAME));
        }
        if (StringUtil.isNotEmpty(KubeUtil.container_id)) {
            pack.put("container", KubeUtil.container_id);
        }
        pack.put("cpu_cores", "4");
        pack.put("host_ip", host_ip);
        DataPackSender.sendToRouter(pack);
    }
}

