/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.net.InetAddress;
import java.util.Random;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.data.DataPackSender;
import whatap.agent.logo.Logo;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.lang.pack.AgentPropertyPack;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.JarUtil;
import whatap.util.KeyGen;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class WsInventory {
    private static final int HEARTBEAT_INTERVAL_SEC = 5;
    private static final int INVENTORY_INTERVAL_SEC = 60;

    public static void main(String[] args) {
        String hostIp;
        short prodid = (short)CastUtil.cint(System.getProperty("prodid", "201"));
        short sysid = (short)CastUtil.cint(System.getProperty("sysid", "1"));
        String oname = System.getProperty("oname");
        if (oname == null || oname.isEmpty()) {
            oname = "infra-mock-" + sysid;
        }
        if ((hostIp = System.getProperty("ip")) == null || hostIp.isEmpty()) {
            hostIp = WsInventory.getLocalIp();
        }
        String csp = System.getProperty("csp", "mock");
        String osType = System.getProperty("osType", "Linux/Mock");
        int cores = CastUtil.cint(System.getProperty("cores", "4"));
        long memory = CastUtil.clong(System.getProperty("memory", "8192"));
        System.setProperty("whatap.disabled", "true");
        if (System.getProperty("whatap.home") == null) {
            String home = JarUtil.getJarLocation(WsInventory.class);
            System.setProperty("whatap.home", home);
        }
        Configure conf = Configure.getInstance();
        conf.waitForInit();
        Configure.TCP_SESSION_ALLOWED = true;
        SecurityMaster sm = SecurityMaster.getInstance();
        sm.PROD_ID = prodid;
        sm.SYS_ID = sysid;
        sm.init();
        sm.ONAME = oname;
        System.setProperty("whatap.name", oname);
        Logo.print();
        System.out.println("=================================================");
        System.out.println("WsInventory - Infrastructure Inventory Simulator");
        System.out.println("=================================================");
        System.out.println("Product ID : " + prodid + " (Server)");
        System.out.println("System ID  : " + sysid);
        System.out.println("Agent Name : " + oname);
        System.out.println("Host IP    : " + hostIp);
        System.out.println("CSP        : " + csp);
        System.out.println("OS Type    : " + osType);
        System.out.println("CPU Cores  : " + cores);
        System.out.println("Memory MB  : " + memory);
        System.out.println("=================================================");
        long seed = DateUtil.currentTime() ^ (long)SysJMX.getProcessPID() << 32;
        KeyGen.setSeed(seed);
        TcpRequestMgr.getInstance();
        TcpSession.getInstance().waitForConnection();
        System.out.println("[" + DateUtil.timestamp() + "] Connected to server. Starting inventory simulation...");
        long lastInventoryTime = 0L;
        Random rand = new Random();
        while (true) {
            long now;
            if ((now = System.currentTimeMillis()) - lastInventoryTime >= 60000L) {
                WsInventory.sendInventory(hostIp, oname, csp, osType, cores, memory, sysid, rand);
                lastInventoryTime = now;
            }
            ThreadUtil.sleep(5000L);
            System.out.println("[" + DateUtil.timestamp() + "] Heartbeat: " + oname);
        }
    }

    private static void sendInventory(String hostIp, String oname, String csp, String osType, int cores, long memory, short sysid, Random rand) {
        SecurityMaster secu = SecurityMaster.getInstance();
        AgentPropertyPack pack = new AgentPropertyPack();
        pack.pcode = secu.PCODE;
        pack.oid = secu.OID;
        pack.time = DateUtil.currentTime();
        pack.put("oname", oname);
        pack.put("prod_name", "server");
        pack.put("prod_level", "standard");
        pack.put("sysid", String.valueOf(sysid));
        pack.put("hostname", oname);
        pack.put("ipAddress", hostIp);
        pack.put("IP_all", hostIp);
        pack.put("OSType", osType);
        pack.put("OSVersion", "Mock OS 1.0.0 x86_64");
        pack.put("serverType", "Virtual");
        pack.put("timezone", "Asia/Seoul (KST, +0900)");
        pack.put("bootTime", DateUtil.timestamp());
        pack.put("cpuType", "x86_64( Mock CPU @ 2.4GHz )");
        pack.put("lCores", String.valueOf(cores));
        pack.put("nCores", String.valueOf(cores / 2 > 0 ? cores / 2 : 1));
        pack.put("x86Socket", "1");
        pack.put("numaNode", "1");
        pack.put("frequency", "2400");
        pack.put("memTotal", String.valueOf(memory));
        pack.put("model", "Mock Server (mock.large)");
        pack.put("hwSerial", "mock-" + secu.OID + "-" + sysid);
        pack.put("firmware", "Mock BIOS 1.0");
        pack.put("gpuCount", "0");
        pack.put("csp", csp);
        pack.put("cloudRegion", "ap-northeast-2");
        pack.put("cloudInstanceId", "i-mock-" + Math.abs(secu.OID));
        pack.put("cloudInstanceName", oname + ".mock.internal");
        pack.put("cloudInstanceType", "mock.large");
        pack.put("cloudInstanceLifeCycle", "on-demand");
        pack.put("cloudImage", "ami-mock-" + sysid);
        pack.put("cloudSecurityGroup", "mock-sg-default");
        pack.put("autoscaleGroup", "");
        pack.put("whatap_infradVersion", "mock-1.0.0");
        pack.put("created_at", String.valueOf(System.currentTimeMillis()));
        pack.put("running", "");
        pack.put("running_count", "0");
        pack.put("running_hash", "0");
        pack.put("listening", "");
        pack.put("listening_count", "0");
        pack.put("listening_hash", "0");
        try {
            DataPackSender.sendToRouter(pack);
            System.out.println("[" + DateUtil.timestamp() + "] Inventory sent: " + oname);
        }
        catch (Exception e) {
            System.err.println("[" + DateUtil.timestamp() + "] Error sending inventory: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String getLocalIp() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
    }
}

