/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataTextAgent;
import whatap.agent.logo.Logo;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.agent.setup.simula.CpuSimula;
import whatap.agent.setup.simula.ErrSimula;
import whatap.agent.setup.simula.HeapSimula;
import whatap.agent.setup.simula.TxSimula;
import whatap.agent.setup.simula.UserSimula;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.HitMapPack1;
import whatap.lang.pack.ProfilePack;
import whatap.lang.pack.RealtimeUserPack1;
import whatap.lang.pack.StatTransactionPack1;
import whatap.lang.pack.TransactionRec;
import whatap.lang.service.TxRecord;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.JarUtil;
import whatap.util.KeyGen;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;
import whatap.util.cardinality.HyperLogLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simula {
    static int[] oids;
    static IntKeyLinkedMap<Agent> agents;
    static String[] agentKind;
    static String[] agentEng;
    static Random r;
    static Runnable txRun;
    private static IntKeyLinkedMap<IntKeyLinkedMap<TransactionRec>> statTx;
    static IntKeyLinkedMap<HitMapPack1> hit;
    public static DataTextAgent.HashedData ONAME;
    public static DataTextAgent.HashedData OKIND_NAME;
    static long last;

    static int rand(int min, int max) {
        return r.nextInt(max - min) + min;
    }

    private static IntKeyLinkedMap<HitMapPack1> createMap() {
        return new IntKeyLinkedMap<HitMapPack1>(){

            @Override
            protected HitMapPack1 create(int oid) {
                HitMapPack1 h = new HitMapPack1();
                h.oid = oid;
                return h;
            }
        };
    }

    private static IntKeyLinkedMap<HitMapPack1> resetHit() {
        IntKeyLinkedMap<HitMapPack1> old = hit;
        hit = Simula.createMap();
        return old;
    }

    public static void addTx(int oid, long etime, int elapsed, boolean isError) {
        hit.intern(oid).add(elapsed, isError);
    }

    public static void main(String[] args) {
        System.setProperty("whatap.disabled", "true");
        System.setProperty("whatap.name", Simula.agents.getFirstValue().oname);
        System.setProperty("text_queue_size", "1000");
        System.setProperty("net_send_queue1_size", "1000");
        if (System.getProperty("whatap.home") == null) {
            String home = JarUtil.getJarLocation(Simula.class);
            System.setProperty("whatap.home", home);
        }
        Configure.getInstance().waitForInit();
        Configure.TCP_SESSION_ALLOWED = true;
        SecurityMaster.getInstance();
        Logo.print();
        long seed = DateUtil.currentTime() ^ (long)SysJMX.getProcessPID() << 32;
        KeyGen.setSeed(seed);
        TcpRequestMgr.getInstance();
        TcpSession.getInstance().waitForConnection();
        long last1m = System.currentTimeMillis() / 60000L * 60000L;
        new Thread(txRun).start();
        block2: while (true) {
            int i;
            long now1m;
            if ((now1m = System.currentTimeMillis() / 60000L * 60000L) != last1m) {
                Simula.sendStat(now1m);
                last1m = now1m;
            }
            Simula.sleepx();
            System.out.println(DateUtil.timestamp());
            IntKeyLinkedMap<HitMapPack1> hmap = Simula.resetHit();
            Enumeration<HitMapPack1> en = hmap.values();
            while (en.hasMoreElements()) {
                HitMapPack1 p = en.nextElement();
                p.pcode = SecurityMaster.getInstance().PCODE;
                p.time = DateUtil.currentTime() / 5000L * 5000L;
                TcpRequestMgr.getInstance().add(0, true, p);
            }
            for (i = 0; i < oids.length; ++i) {
                Agent agent = agents.get(oids[i]);
                CounterPack1 pw = new CounterPack1();
                pw.time = DateUtil.currentTime() / 5000L * 5000L;
                pw.duration = 5;
                pw.active_tx_slice = new short[]{(short)Simula.rand(1, 3), (short)Simula.rand(1, 3), (short)Simula.rand(1, 3)};
                pw.active_tx_count = Simula.sum(pw.active_tx_slice);
                pw.tps = Simula.rand(1, 10);
                pw.resp_time = Simula.rand(0, 3000);
                pw.cpu = CpuSimula.getCpu(agent.oid, agent.kind, pw.time);
                pw.heap_max = pw.heap_tot = HeapSimula.getTot(agent.kind, agent.okind);
                pw.heap_use = HeapSimula.getUse(agent.oid, agent.kind, agent.okind, pw.time);
                pw.host_ip = agent.oid;
                pw.arrival_rate = pw.tps;
                pw.apdex_satisfied = (int)(pw.tps * 5.0f / 2.0f);
                pw.apdex_tolerated = (int)(pw.tps * 5.0f / 2.0f);
                pw.apdex_total = pw.service_count = (int)(pw.tps * 5.0f);
                try {
                    pw.pcode = SecurityMaster.getInstance().PCODE;
                    pw.oid = agent.oid;
                    pw.okind = agent.okind;
                    TcpRequestMgr.getInstance().add(0, true, pw);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ONAME.add(agent.oid, agent.oname);
                HyperLogLog hll = UserSimula.getUser(agent.oid, agent.kind, pw.time);
                RealtimeUserPack1 pk = new RealtimeUserPack1();
                pk.time = pw.time;
                pk.cadinality = (int)hll.cardinality();
                pk.logbits = hll.getBytes();
                pk.pcode = SecurityMaster.getInstance().PCODE;
                pk.oid = agent.oid;
                pk.okind = agent.okind;
                TcpRequestMgr.getInstance().add(0, true, pk);
            }
            i = 0;
            while (true) {
                if (i >= agentKind.length) continue block2;
                OKIND_NAME.add(HashUtil.hash(agentKind[i]), agentKind[i]);
                if (i % 10 == 0) {
                    ThreadUtil.sleep(1L);
                }
                ++i;
            }
            break;
        }
    }

    private static void sendStat(long now) {
        int[] oids;
        for (int oid : oids = statTx.keyArray()) {
            IntKeyLinkedMap<TransactionRec> table = statTx.remove(oid);
            ArrayList<TransactionRec> out = new ArrayList<TransactionRec>(table.size() + 10);
            Enumeration<TransactionRec> en = table.values();
            while (en.hasMoreElements()) {
                out.add(en.nextElement());
            }
            StatTransactionPack1 p = new StatTransactionPack1(2306);
            p.dataStartTime = now - 60000L;
            p.dataEndTime = now;
            p.pcode = SecurityMaster.getInstance().PCODE;
            p.oid = oid;
            p.okind = Simula.agents.get((int)oid).okind;
            p.time = now;
            p.spec = ConfMTrace.mtrace_spec_hash;
            p.version = ConfStat.stat_service_version;
            p.setRecords(out);
            TcpRequestMgr.getInstance().add(0, false, p);
        }
    }

    private static int sum(short[] s) {
        return s[0] + s[1] + s[2];
    }

    private static void sleepx() {
        while (true) {
            long now;
            if ((now = DateUtil.currentTime() / 5000L * 5000L) != last) {
                last = now;
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }

    static {
        agents = new IntKeyLinkedMap();
        agentKind = new String[]{"\ud559\uc801", "\ub4f1\ub85d", "\uc878\uc5c5", "\ud734\ud559", "\ubcf5\ud559", "\uac15\uc758", "\uc2dc\ud5d8", "\uc131\uc801", "\uc7a5\ud559", "\uc0c1\ub2f4", "\ub3c4\uc11c\uad00", "\uc785\ud559", "\ucd9c\uc11d", "\ud559\uc0ac\uc5c5\ubb34", "\uacfc\uc81c", "\ucc44\uc6a9", "\uc5f0\uad6c", "\ub3d9\uc544\ub9ac", "\ub300\uc678\uc5c5\ubb34", "\uc778\ud134\uc2ed", "\uae30\uc219\uc0ac", "\uc2dd\ub2f9", "\uad50\ud658\ud559\uc0dd", "\uc608\uc0b0", "\uacb0\uc81c", "\uc2dc\uc124\uad00\ub9ac", "\uc720\uc9c0\ubcf4\uc218", "\uacf5\uc9c0", "\uc774\uba54\uc77c", "\ud3c9\uac00", "\uc77c\uc815", "\uc138\ubbf8\ub098", "\uc878\uc5c5", "\ubb38\uc11c", "\uc124\ubb38", "\ud3ec\ud138", "\uacc4\uc815", "\uc778\uc99d", "\uacfc\ubaa9", "\uacc4\uc88c", "\uc99d\uba85\uc11c", "\ucd9c\uacb0\uae30\ub85d", "\uce74\ub4dc", "\uc608\ube44", "\uacf5\ubaa8\uc804", "\uac15\uc758\uc2dc\ub9ac\uc988", "\uc790\ub8cc", "\ubcf4\uace0\uc11c", "\uc2dc\uac04", "\ud68c\uc758", "\uc774\ubca4\ud2b8", "\uc628\ub77c\uc778", "\ucd9c\ud310", "\uad11\uace0", "\uc54c\ub9bc", "\uba74\uc811", "\uacc4\uc57d", "\uad00\ub9ac", "\uae30\ud68d", "\uc7ac\ubb34", "\ud68c\uacc4", "\ud64d\ubcf4", "\uae30\ubd80", "\ud3c9\uac00", "\uc9c0\ub3c4"};
        agentEng = new String[]{"Academic-Record", "Registration", "Graduation", "Leave-of-Absence", "Reinstatement", "Lecture", "Exam", "Grade", "Scholarship", "Counseling", "Library", "Admission", "Attendance", "Academic-Affairs", "Assignment", "Recruitment", "Research", "Club", "External-Affairs", "Internship", "Dormitory", "Cafeteria", "Student-Exchange", "Budget", "Payment", "Facility-Management", "Maintenance", "Notice", "Email", "Evaluation", "Schedule", "Seminar", "Graduation", "Document", "Survey", "Portal", "Account", "Authentication", "Course", "Bank-Account", "Certificate", "Attendance-Record", "Card", "Preliminary", "Contest", "Lecture-Series", "Resource", "Report", "Time", "Meeting", "Event", "Online", "Publication", "Advertisement", "Notification", "Interview", "Contract", "Management", "Planning", "Finance", "Accounting", "Promotion", "Donation", "Assessment", "Guidance"};
        r = new Random();
        for (int i = 0; i < agentKind.length; ++i) {
            int n = Simula.rand(2, 5);
            for (int j = 1; j <= n; ++j) {
                String oname = agentEng[i] + "-(" + agentKind[i] + ")-" + j;
                int oid = HashUtil.hash(oname);
                int okind = HashUtil.hash(agentKind[i]);
                String kind = agentKind[i];
                agents.put(oid, new Agent(oid, oname, okind, kind));
            }
        }
        oids = agents.keyArray();
        txRun = new Runnable(){

            public void run() {
                int n = 0;
                int u = 0;
                while (true) {
                    try {
                        while (true) {
                            Agent agent = agents.get(oids[n]);
                            TxRecord tx = new TxRecord();
                            tx.txid = KeyGen.next();
                            tx.service = TxSimula.getService(n);
                            tx.wclientId = KeyGen.next();
                            tx.endTime = System.currentTimeMillis();
                            tx.ipaddr = agent.oid;
                            tx.domain = TxSimula.getDomain(agent.okind);
                            tx.elapsed = TxSimula.getElapsed(agent.okind, agent.kind, tx.endTime);
                            tx.error = ErrSimula.getError(agent.oid, agent.kind, tx.elapsed);
                            tx.httpcCount = 2;
                            tx.httpcTime = (int)((double)tx.elapsed * 0.3);
                            tx.sqlCount = 5;
                            tx.sqlTime = (int)((double)tx.elapsed * 0.5);
                            tx.sqlFetchCount = 3000;
                            tx.sqlFetchTime = (int)((double)tx.elapsed * 0.2);
                            ProfilePack profile = new ProfilePack();
                            profile.pcode = SecurityMaster.getInstance().PCODE;
                            profile.time = tx.endTime;
                            profile.oid = agent.oid;
                            profile.okind = agent.okind;
                            profile.transaction = tx;
                            TcpRequestMgr.getInstance().addProfile(0, false, profile);
                            if (++n >= oids.length) {
                                n = 0;
                            }
                            TransactionRec r = (TransactionRec)((IntKeyLinkedMap)statTx.intern(profile.oid)).intern(tx.service);
                            r.setUrlHash(tx.service);
                            ++r.count;
                            if (tx.error != 0L) {
                                ++r.error;
                            }
                            r.time_max = Math.max(r.time_max, tx.elapsed);
                            r.time_sum += (long)tx.elapsed;
                            r.time_sqr_sum += (long)(tx.elapsed * tx.elapsed);
                            Simula.addTx(profile.oid, tx.endTime, tx.elapsed, tx.error != 0L);
                            if (++u >= TxSimula.length()) {
                                u = 0;
                            }
                            ThreadUtil.sleep(1L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        statTx = new IntKeyLinkedMap<IntKeyLinkedMap<TransactionRec>>(){

            @Override
            protected IntKeyLinkedMap<TransactionRec> create(int key) {
                return new IntKeyLinkedMap<TransactionRec>(){

                    @Override
                    protected TransactionRec create(int key) {
                        return new TransactionRec();
                    }
                };
            }
        };
        hit = Simula.createMap();
        ONAME = new DataTextAgent.HashedData(13, 1000);
        OKIND_NAME = new DataTextAgent.HashedData(57, 1000);
        last = DateUtil.currentTime() / 5000L * 5000L;
    }

    static class Agent {
        int oid;
        String oname;
        int okind;
        String kind;

        public Agent(int oid, String oname, int okind, String kind) {
            this.oid = oid;
            this.oname = oname;
            this.okind = okind;
            this.kind = kind;
        }
    }
}

