/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import whatap.agent.logo.Logo;
import whatap.util.FileUtil;
import whatap.util.FormatUtil;
import whatap.util.JarUtil;
import whatap.util.ShellArg;
import whatap.util.StringUtil;

public class Rename {
    public static boolean debug = false;
    public static boolean show_dir = false;
    public static boolean show_file = false;

    public static void main(String[] args) throws Exception {
        String to;
        Logo.printForUtil();
        ShellArg sh = new ShellArg(args);
        String from = sh.get("-from");
        if (from == null) {
            from = JarUtil.getJarFileName(Rename.class);
        }
        if (StringUtil.isEmpty(to = sh.get("-to")) || !new File(from).exists()) {
            Rename.usage();
        }
        File fromFile = new File(from);
        File toFile = new File(to);
        Rename.process(fromFile, toFile);
        System.out.println("  Org Agent: " + fromFile.getName() + " " + FormatUtil.print(fromFile.length(), "#,##0") + "bytes");
        System.out.println("  New Agent: " + toFile.getName() + " " + FormatUtil.print(toFile.length(), "#,##0") + "bytes created successfully");
        System.out.println();
    }

    private static void process(File from, File to) throws IOException {
        JarFile jf = new JarFile(from);
        Manifest mf = jf.getManifest();
        mf.getMainAttributes().putValue("Boot-Class-Path", to.getName());
        JarOutputStream os = new JarOutputStream((OutputStream)new FileOutputStream(to), mf);
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            if (e.getName().equals("META-INF/MANIFEST.MF")) continue;
            os.putNextEntry(e);
            InputStream is = jf.getInputStream(e);
            byte[] b = FileUtil.readAll(is);
            os.write(b);
            is.close();
            os.closeEntry();
        }
        os.close();
    }

    private static void usage() {
        System.out.println("Usage: java -cp " + JarUtil.getJarFileName(Rename.class) + "  \\ \n\t " + Rename.class.getName() + "  [-from orginAgentJar]  -to newAgentJar");
        System.out.println();
        System.exit(1);
    }

    public static String c(String name) {
        return name.replace('/', '.');
    }
}

