/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import whatap.agent.logo.Logo;
import whatap.util.FileUtil;
import whatap.util.FormatUtil;
import whatap.util.JarUtil;

public class JarSize {
    public static boolean debug = false;
    public static boolean show_dir = false;
    public static boolean show_file = false;

    public static void main(String[] args) throws Exception {
        Logo.printForUtil();
        String jar = args.length >= 1 ? args[0] : JarUtil.getJarFileName(JarSize.class);
        JarSize.process(new File(jar));
    }

    private static void process(File from) throws IOException {
        int cnt = 0;
        long tot = 0L;
        JarFile jf = new JarFile(from);
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            InputStream is = jf.getInputStream(e);
            byte[] b = FileUtil.readAll(is);
            ++cnt;
            tot += (long)b.length;
            System.out.println(" " + e.getName() + " " + FormatUtil.print(b.length, "#,##0"));
        }
        System.out.println();
        System.out.println(" entry " + cnt + " size " + FormatUtil.print(tot, "#,##0"));
        System.out.println();
    }
}

