/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.proxy;

import java.io.PrintWriter;
import java.util.List;
import whatap.agent.Logger;
import whatap.agent.conf.ConfHook;
import whatap.agent.proxy.IToolsMain;
import whatap.agent.proxy.LoaderManager;
import whatap.lang.pack.ParamPack;
import whatap.lang.value.ListValue;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;
import whatap.util.ThreadUtil;

public class ToolsMainFactory {
    private static final String TOOLS_MAIN = "whatap.xtra.tools.ToolsMain";
    public static boolean activeStack = false;

    public static ListValue heaphisto(String filter) throws Throwable {
        ListValue m = new ListValue();
        if (SystemUtil.IS_JAVA_1_5) {
            throw new Exception("Not supported java version : " + SystemUtil.JAVA_VERSION);
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            throw new Exception("Not supported java vendor : " + SystemUtil.JAVA_VENDOR);
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            return null;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            throw new Exception("Not supported java vendor : " + SystemUtil.JAVA_VENDOR);
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            List<String> out = toolsMain.heaphisto(0, 100000, "all");
            if (StringUtil.isEmpty(filter)) {
                for (int i = 0; i < 100; ++i) {
                    String histo = out.get(i);
                    m.add(histo);
                }
            } else {
                for (int i = 0; i < out.size() && m.size() < 100; ++i) {
                    String histo = out.get(i);
                    if (histo.indexOf(filter) < 0) continue;
                    m.add(histo);
                }
            }
        }
        catch (Exception e) {
            Logger.println(e.getMessage());
        }
        return m;
    }

    public static void heaphisto(PrintWriter out) throws Throwable {
        if (!ConfHook._enable_emb_tools) {
            return;
        }
        if (SystemUtil.IS_JAVA_1_5) {
            return;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            return;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            toolsMain.heaphisto(out);
        }
        catch (Throwable e) {
            Logger.println(e.getMessage());
        }
    }

    public static ParamPack threadDump(ParamPack m) throws Throwable {
        if (SystemUtil.IS_JAVA_1_5 || SystemUtil.JAVA_VENDOR.startsWith("IBM") || !ConfHook._enable_emb_tools) {
            List<String> out = ThreadUtil.getThreadDumpList();
            ListValue lv = m.newList("data");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
            return m;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            List<String> out = ThreadUtil.getThreadDumpList();
            ListValue lv = m.newList("data");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
        }
        try {
            if (loader != null) {
                Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
                IToolsMain toolsMain = (IToolsMain)c.newInstance();
                List<String> out = toolsMain.threadDump(0, 100000);
                ListValue lv = m.newList("data");
                for (int i = 0; i < out.size(); ++i) {
                    lv.add(out.get(i));
                }
            }
        }
        catch (Throwable e) {
            Logger.println(e.getMessage());
        }
        return m;
    }

    public static void threadDump(PrintWriter out) throws Throwable {
        activeStack = true;
        if (SystemUtil.IS_JAVA_1_5 || SystemUtil.JAVA_VENDOR.startsWith("IBM") || !ConfHook._enable_emb_tools) {
            out.print(ThreadUtil.getThreadDump());
            return;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            out.print(ThreadUtil.getThreadDump());
            return;
        }
        try {
            if (loader != null) {
                Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
                IToolsMain toolsMain = (IToolsMain)c.newInstance();
                toolsMain.threadDump(out);
            }
        }
        catch (Throwable e) {
            Logger.println(e.getMessage());
        }
    }
}

