/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.proxy;

import whatap.agent.Logger;
import whatap.agent.jdbc.JdbcUrls;
import whatap.agent.jdbc.SqlTrace;
import whatap.agent.proxy.LoaderManager;
import whatap.agent.trace.sql.ISqlTrace;
import whatap.agent.trace.sql.SID;
import whatap.lang.value.TextValue;
import whatap.util.SystemUtil;

public class SqlTraceFactory {
    private static final String SQL_TRACE = "whatap.xtra.sql.SqlTrace";
    public static final ISqlTrace java8 = new SqlTrace();
    public static final ISqlTrace java9dummy = new ISqlTrace(){

        public Object wrapConnection(Object conn, int dbc, int url) {
            return conn;
        }

        public Object wrapResultSet(Object rs, int sqlhash, int dbc) {
            return rs;
        }

        public int getUrlHashFromStatement(Object o, TextValue conName) {
            return JdbcUrls.getURLHashDummy("unknown");
        }

        public int getUrlHashFromStatement(Object o) {
            return JdbcUrls.getURLHashDummy("unknown");
        }

        public int getURLHashFromConnection(String poolClassName, Object conn) {
            return JdbcUrls.getURLHashDummy("unknown");
        }

        public int getHashKey(Object conn) {
            return System.identityHashCode(conn);
        }

        public SID getConnectionSid(Object conn) {
            return null;
        }

        public String getDBType(Object conn) {
            return "";
        }

        public int getErrorCode(Throwable t) {
            return 0;
        }
    };

    public static ISqlTrace create(ClassLoader parent) {
        if (!SystemUtil.IS_JAVA_OVER9()) {
            return java8;
        }
        try {
            ClassLoader loader = LoaderManager.getSqlTraceLoader(parent);
            if (loader == null) {
                return java9dummy;
            }
            Class<?> c = Class.forName(SQL_TRACE, true, loader);
            return (ISqlTrace)c.newInstance();
        }
        catch (Throwable e) {
            Logger.println("A401", 10, "fail to create", e);
            return java9dummy;
        }
    }
}

