/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.proxy;

import java.lang.ref.WeakReference;
import whatap.agent.Logger;
import whatap.agent.proxy.HttpCtx;
import whatap.agent.proxy.HttpTraceFactory;
import whatap.agent.proxy.IHttpTrace;
import whatap.agent.proxy.LoaderManager;
import whatap.util.SystemUtil;

public class HttpJakartaFactory {
    private static final String HTTP_JAKARTA = "whatap.xtra.jakarta.HttpTrace";
    private static final String HTTP_VALVE_JAKARTA = "whatap.xtra.jakarta.HttpValveTrace";
    public static final IHttpTrace dummy = new IHttpTrace(){

        public HttpCtx wrap(Object req, Object res) {
            return null;
        }
    };

    public static IHttpTrace create(ClassLoader parent) {
        try {
            ClassLoader loader = LoaderManager.getHttpJakartaLoader(parent);
            if (loader == null) {
                return dummy;
            }
            if (SystemUtil.IS_JAVA_OVER9() && parent != null) {
                HttpTraceFactory.httpLoader = new WeakReference<ClassLoader>(parent);
            }
            Class<?> c = Class.forName(HTTP_JAKARTA, true, loader);
            return (IHttpTrace)c.newInstance();
        }
        catch (Throwable e) {
            Logger.println("HttpJakartaFactory", 10, "fail to create", e);
            return dummy;
        }
    }

    public static IHttpTrace createValve(ClassLoader parent) {
        try {
            ClassLoader loader = LoaderManager.getHttpJakartaLoader(parent);
            if (loader == null) {
                return dummy;
            }
            if (SystemUtil.IS_JAVA_OVER9() && parent != null) {
                HttpTraceFactory.httpLoader = new WeakReference<ClassLoader>(parent);
            }
            Class<?> c = Class.forName(HTTP_VALVE_JAKARTA, true, loader);
            return (IHttpTrace)c.newInstance();
        }
        catch (Throwable e) {
            Logger.println("HttpJakartaFactory", 10, "fail to create", e);
            return dummy;
        }
    }
}

