/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import whatap.agent.Logger;
import whatap.agent.plugin.WrSession;
import whatap.agent.plugin.Wrapper;

public class WrRequest
extends Wrapper {
    private Object reqObject;
    private Method getRequestURI;
    private Method getRemoteAddr;
    private Method getMethod;
    private Method getParameterNames;
    private Method getParameter;
    private Method getHeaderNames;
    private Method getHeader;
    private Method getQueryString;
    private Method getSession;
    private Method getCookies;
    private Method getName;
    private Method getValue;
    private Method getSessionAttribute;
    private Method getAttribute;
    private Method setCharacterEncoding;
    private Method getContentType;
    private Method getRequestedSessionId;
    private boolean enabled = true;
    private Throwable _error = null;

    public WrRequest(Object req) {
        this.reqObject = req;
    }

    public String getCookie(String key) {
        if (!this.enabled) {
            return null;
        }
        try {
            Object[] c;
            if (this.getCookies == null) {
                this.getCookies = this.reqObject.getClass().getMethod("getCookies", arg_c);
                this.getCookies.setAccessible(true);
            }
            if ((c = (Object[])this.getCookies.invoke(this.reqObject, arg_o)) == null && c.length == 0) {
                return null;
            }
            if (this.getName == null) {
                this.getName = c[0].getClass().getMethod("getName", arg_c);
                this.getName.setAccessible(true);
            }
            if (this.getValue == null) {
                this.getValue = c[0].getClass().getMethod("getValue", arg_c);
                this.getValue.setAccessible(true);
            }
            for (int i = 0; i < c.length; ++i) {
                if (!key.equals(this.getName.invoke(c[i], arg_o))) continue;
                return (String)this.getValue.invoke(c[i], arg_o);
            }
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
        }
        return null;
    }

    public String getRequestURI() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getRequestURI == null) {
                this.getRequestURI = this.reqObject.getClass().getMethod("getRequestURI", arg_c);
                this.getRequestURI.setAccessible(true);
            }
            return (String)this.getRequestURI.invoke(this.reqObject, arg_o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A179", 10, e);
            return null;
        }
    }

    public String getRemoteAddr() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getRemoteAddr == null) {
                this.getRemoteAddr = this.reqObject.getClass().getMethod("getRemoteAddr", arg_c);
                this.getRemoteAddr.setAccessible(true);
            }
            return (String)this.getRemoteAddr.invoke(this.reqObject, arg_o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A180", 10, e);
            return null;
        }
    }

    public String getMethod() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getMethod == null) {
                this.getMethod = this.reqObject.getClass().getMethod("getMethod", arg_c);
                this.getMethod.setAccessible(true);
            }
            return (String)this.getMethod.invoke(this.reqObject, arg_o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A181", 10, e);
            return null;
        }
    }

    public String getQueryString() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getQueryString == null) {
                this.getQueryString = this.reqObject.getClass().getMethod("getQueryString", arg_c);
                this.getQueryString.setAccessible(true);
            }
            return (String)this.getQueryString.invoke(this.reqObject, arg_o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A182", 10, e);
            return null;
        }
    }

    public boolean isMultipartContent(String contentType) {
        return contentType != null && contentType.indexOf("multipart") >= 0;
    }

    public boolean isFormUrlencoded(String contentType) {
        return contentType != null && contentType.startsWith("application/x-www-form-urlencoded");
    }

    public String getContentType() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getContentType == null) {
                this.getContentType = this.reqObject.getClass().getMethod("getContentType", arg_c);
                this.getContentType.setAccessible(true);
            }
            return (String)this.getContentType.invoke(this.reqObject, arg_o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A182", 10, e);
            return null;
        }
    }

    public String getParameter(String key) {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getParameter == null) {
                this.getParameter = this.reqObject.getClass().getMethod("getParameter", arg_c_s);
                this.getParameter.setAccessible(true);
            }
            return (String)this.getParameter.invoke(this.reqObject, key);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A183", 10, e);
            return null;
        }
    }

    public Object getAttribute(String key) {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getAttribute == null) {
                this.getAttribute = this.reqObject.getClass().getMethod("getAttribute", arg_c_s);
                this.getAttribute.setAccessible(true);
            }
            return this.getAttribute.invoke(this.reqObject, key);
        }
        catch (Throwable e) {
            this.enabled = false;
            Logger.println("A184", 10, e);
            return null;
        }
    }

    public String getHeader(String key) {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getHeader == null) {
                this.getHeader = this.reqObject.getClass().getMethod("getHeader", arg_c_s);
                this.getHeader.setAccessible(true);
            }
            return (String)this.getHeader.invoke(this.reqObject, key);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A185", 10, e);
            return null;
        }
    }

    public void setCharacterEncoding(String key) {
        if (!this.enabled) {
            return;
        }
        try {
            if (this.setCharacterEncoding == null) {
                this.setCharacterEncoding = this.reqObject.getClass().getMethod("setCharacterEncoding", arg_c_s);
                this.setCharacterEncoding.setAccessible(true);
            }
            this.setCharacterEncoding.invoke(this.reqObject, key);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A185", 10, e);
        }
    }

    public Enumeration getParameterNames() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getParameterNames == null) {
                this.getParameterNames = this.reqObject.getClass().getMethod("getParameterNames", arg_c);
                this.getParameterNames.setAccessible(true);
            }
            return (Enumeration)this.getParameterNames.invoke(this.reqObject, arg_o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A186", 10, e);
            return null;
        }
    }

    public Enumeration getHeaderNames() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getHeaderNames == null) {
                this.getHeaderNames = this.reqObject.getClass().getMethod("getHeaderNames", arg_c);
                this.getHeaderNames.setAccessible(true);
            }
            return (Enumeration)this.getHeaderNames.invoke(this.reqObject, arg_o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            return null;
        }
    }

    public WrSession getSession() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getSession == null) {
                this.getSession = this.reqObject.getClass().getMethod("getSession", arg_c_z);
                this.getSession.setAccessible(true);
            }
            Object o = this.getSession.invoke(this.reqObject, false);
            return new WrSession(o);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A187", 10, e);
            return null;
        }
    }

    public Set getSessionNames() {
        if (!this.enabled) {
            return null;
        }
        try {
            Object o;
            TreeSet names = new TreeSet();
            if (this.getSession == null) {
                this.getSession = this.reqObject.getClass().getMethod("getSession", arg_c_z);
                this.getSession.setAccessible(true);
            }
            if ((o = this.getSession.invoke(this.reqObject, false)) == null) {
                return names;
            }
            Enumeration en = new WrSession(o).getAttributeNames();
            if (en != null) {
                while (en.hasMoreElements()) {
                    names.add(en.nextElement());
                }
            }
            return names;
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A188", 10, e);
            return null;
        }
    }

    public Object getSessionAttribute(String key) {
        if (!this.enabled) {
            return null;
        }
        try {
            Object o;
            if (this.getSession == null) {
                this.getSession = this.reqObject.getClass().getMethod("getSession", arg_c_z);
                this.getSession.setAccessible(true);
            }
            if ((o = this.getSession.invoke(this.reqObject, false)) == null) {
                return null;
            }
            if (this.getSessionAttribute == null) {
                this.getSessionAttribute = o.getClass().getMethod("getAttribute", arg_c_s);
                this.getSessionAttribute.setAccessible(true);
            }
            return this.getSessionAttribute.invoke(o, key);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A189", 10, e);
            return null;
        }
    }

    public String getRequestedSessionId() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getRequestedSessionId == null) {
                this.getRequestedSessionId = this.reqObject.getClass().getMethod("getRequestedSessionId", new Class[0]);
                this.getRequestedSessionId.setAccessible(true);
            }
            return (String)this.getRequestedSessionId.invoke(this.reqObject, new Object[0]);
        }
        catch (Throwable e) {
            this.enabled = false;
            this._error = e;
            Logger.println("A190", 10, e);
            return null;
        }
    }

    public Object inner() {
        return this.reqObject;
    }

    public boolean isOk() {
        return this.enabled;
    }

    public Throwable error() {
        return this._error;
    }
}

