/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.pii;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPIIMask;
import whatap.agent.pii.PiiItem;
import whatap.lang.pack.LogSinkPack;
import whatap.util.IntLinkedSet;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class PiiMask {
    static StringKeyLinkedMap<List<PiiItem>> table = new StringKeyLinkedMap();
    static List<Pattern> sqlMask = new ArrayList<Pattern>();
    static String confLogSink = "";
    static String confSql = "";
    private static IntLinkedSet sql_p1_has = new IntLinkedSet().setMax(5000);
    private static IntLinkedSet sql_p1_not = new IntLinkedSet().setMax(5000);
    private static IntLinkedSet sql_p2_has = new IntLinkedSet().setMax(5000);
    private static IntLinkedSet sql_p2_not = new IntLinkedSet().setMax(5000);

    public static void update() {
        PiiMask.updateLogSink();
        PiiMask.updateSql();
    }

    private static void updateLogSink() {
        String[] ids;
        String val = StringUtil.trimToEmpty(ConfPIIMask.pii_mask_logsink_items);
        if (val.equals(confLogSink)) {
            return;
        }
        confLogSink = val;
        StringKeyLinkedMap<List<PiiItem>> tmp = new StringKeyLinkedMap<List<PiiItem>>(){

            @Override
            protected List<PiiItem> create(String key) {
                return new ArrayList<PiiItem>();
            }
        };
        for (String id : ids = StringUtil.tokenizer(val, ",")) {
            String category = ConfPIIMask.getLogSinkProperty(id, "category");
            String pattern = ConfPIIMask.getLogSinkProperty(id, "pattern");
            String field = ConfPIIMask.getLogSinkProperty(id, "field");
            String replace = ConfPIIMask.getLogSinkProperty(id, "replace");
            if (StringUtil.isEmpty(category) || StringUtil.isEmpty(pattern)) {
                Logger.println("logsink pii config for [" + id + "] is empty or invalid");
                continue;
            }
            if (StringUtil.isEmpty(replace)) {
                replace = ConfPIIMask.pii_mask_logsink_replace;
            }
            ((List)tmp.intern(category)).add(new PiiItem(field, pattern, replace));
        }
        table = tmp;
    }

    public static void updateSql() {
        String[] ids;
        String val = StringUtil.trimToEmpty(ConfPIIMask.pii_mask_sql_items);
        if (val.equals(confSql)) {
            return;
        }
        confSql = val;
        ArrayList<Pattern> tmp = new ArrayList<Pattern>();
        for (String id : ids = StringUtil.tokenizer(val, ",")) {
            String pattern = ConfPIIMask.getSqlProperty(id, "pattern");
            if (StringUtil.isEmpty(pattern)) {
                Logger.println("sql pii config for [" + id + "] is empty or invalid");
                continue;
            }
            tmp.add(Pattern.compile(pattern));
        }
        sqlMask = tmp;
    }

    public static void parseLogSink(LogSinkPack p) {
        List<PiiItem> list = table.get(p.category);
        if (list == null) {
            return;
        }
        for (PiiItem pm : list) {
            pm.mask(p);
        }
    }

    public static String parseSqlP1(int sqlHash, String param) {
        if (sqlMask.size() == 0 || StringUtil.isEmpty(param)) {
            return param;
        }
        return PiiMask.exec(sqlHash, param, sql_p1_has, sql_p1_not);
    }

    public static String parseSqlP2(int sqlHash, String param) {
        if (sqlMask.size() == 0 || StringUtil.isEmpty(param)) {
            return param;
        }
        return PiiMask.exec(sqlHash, param, sql_p2_has, sql_p2_not);
    }

    private static String exec(int sqlHash, String param, IntLinkedSet sql_has, IntLinkedSet sql_not) {
        if (sql_not.contains(sqlHash)) {
            return param;
        }
        if (sql_has.contains(sqlHash)) {
            return ConfPIIMask.pii_mask_sql_replace;
        }
        for (Pattern m : sqlMask) {
            Matcher match = m.matcher(param);
            if (!match.matches()) continue;
            sql_has.put(sqlHash);
            return ConfPIIMask.pii_mask_sql_replace;
        }
        sql_not.put(sqlHash);
        return param;
    }
}

