/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.CypherConf;
import whatap.agent.net.TcpReturn;
import whatap.agent.util.OidUtil;
import whatap.io.DataIOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.WsKey;
import whatap.util.AnsiPrint;
import whatap.util.ArrayUtil;
import whatap.util.FileUtil;
import whatap.util.HashUtil;
import whatap.util.IPUtil;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.SystemUtil;
import whatap.util.ThreadUtil;

public class TcpSession
extends Thread {
    private static TcpSession worker;
    private final Object closeLock = new Object();
    protected Socket socket = null;
    DataInputX din = null;
    DataOutputX dout = null;
    public boolean newly_opened = false;
    public static long last_connected_time;
    protected static boolean okMacAddress;
    private static int auto_oname_reset;
    public static int whatap_name_reset;
    protected final Object sendLock = new Object();
    public static int connection_localport;
    public static long lastReceiveTime;
    static final int READ_MAX = 0x800000;
    Configure conf = Configure.getInstance();
    SecurityMaster secuMaster = SecurityMaster.getInstance();
    static TcpReturn empty;

    public static synchronized TcpSession getInstance() {
        if (worker == null) {
            worker = new TcpSession();
            worker.setName("WhaTap-TcpSession");
            worker.setDaemon(true);
            worker.start();
        }
        return worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.din == null && this.dout == null && this.socket == null) {
                return;
            }
            if (this.din != null) {
                Logger.println("TcpClose", AnsiPrint.red("The WhaTap Connection is closed: pcode=" + this.secuMaster.PCODE + " oid=" + this.secuMaster.OID + " oname=" + System.getProperty("whatap.oname")));
            }
            last_connected_time = 0L;
            FileUtil.close(this.din);
            FileUtil.close(this.dout);
            FileUtil.close(this.socket);
            this.socket = null;
            this.din = null;
            this.dout = null;
        }
    }

    public static boolean isStaticOpen() {
        if (worker == null) {
            return false;
        }
        return TcpSession.worker.socket != null;
    }

    public boolean isOpen() {
        return this.socket != null;
    }

    public boolean open() {
        if (this.isOpen()) {
            return true;
        }
        if (this.secuMaster.PCODE == 0L) {
            return false;
        }
        if (!Configure.TCP_SESSION_ALLOWED) {
            return false;
        }
        String host = this.conf.getWhatapServerHost();
        int port = this.conf.whatap_server_port;
        int connection_timeout = this.conf.tcp_connection_timeout;
        int so_timeout = this.conf.tcp_so_timeout;
        Socket conn = new Socket();
        try {
            String oname;
            conn.connect(new InetSocketAddress(InetAddress.getByName(host), port), connection_timeout);
            DataInputX in = new DataInputX(new BufferedInputStream(conn.getInputStream()));
            DataOutputX out = new DataOutputX(new BufferedOutputStream(conn.getOutputStream()));
            InetAddress local = conn.getLocalAddress();
            String localAddr = local.getHostAddress();
            if (Configure.getInstance().auto_oname_enabled && StringUtil.isEmpty(oname = System.getProperty("whatap.oname")) && auto_oname_reset == this.conf.auto_oname_reset) {
                conn.setSoTimeout(this.conf.auto_oname_so_timeout);
                this.prepareAutoOnameByServer(in, out, localAddr);
                auto_oname_reset = this.conf.auto_oname_reset;
            }
            if (SecurityMaster.isWorkspace && this.secuMaster.SYS_ID == 0) {
                conn.setSoTimeout(this.conf.auto_oname_so_timeout);
                short sysid = this.prepareSysIdByServer(in, out);
                if (sysid <= 0) {
                    this.close();
                    return false;
                }
            }
            conn.setSoTimeout(so_timeout);
            if (this.conf.recvBuf > 0) {
                conn.setReceiveBufferSize(this.conf.recvBuf);
            }
            if (this.conf.sendBuf > 0) {
                conn.setSendBufferSize(this.conf.sendBuf);
            }
            Logger.println("TcpOpen", "SendBufferSize: " + conn.getSendBufferSize() + ", ReceiveBufferSize : " + conn.getReceiveBufferSize());
            int mac = 0;
            try {
                NetworkInterface netif;
                if (okMacAddress && (netif = NetworkInterface.getByInetAddress(local)) != null) {
                    byte[] macBytes = netif.getHardwareAddress();
                    mac = macBytes == null ? 0 : HashUtil.hash(macBytes);
                }
            }
            catch (Throwable t) {
                okMacAddress = false;
            }
            if (whatap_name_reset != Configure.getInstance().whatap_name_reset) {
                try {
                    System.clearProperty("whatap.name");
                    System.clearProperty("whatap.oname");
                    System.clearProperty("whatap.oid");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                whatap_name_reset = Configure.getInstance().whatap_name_reset;
            }
            this.secuMaster.decideAgentOnameOid(localAddr, mac);
            try {
                out.write(this.keyReset());
                out.flush();
            }
            catch (DataIOException ie) {
                Logger.println("TcpOpen", 10, "fail to reset the tcp session key " + host + ":" + port, ie);
                this.close();
                return false;
            }
            byte[] data = this.readKeyReset(in);
            if (ArrayUtil.isEmpty(data)) {
                FileUtil.close(in);
                FileUtil.close(out);
                FileUtil.close(conn);
                return false;
            }
            CypherConf.updateNetCypherKey(data);
            this.din = in;
            this.dout = out;
            this.socket = conn;
            this.newly_opened = true;
            if (SecurityMaster.isWorkspace) {
                Logger.println("TcpOpen", AnsiPrint.green("The WhaTap Connection is open: " + host + ":" + port + " ws=" + WsKey.createFromPcode(this.secuMaster.PCODE) + " oid=" + this.secuMaster.OID + " oname=" + System.getProperty("whatap.oname")));
            } else {
                Logger.println("TcpOpen", AnsiPrint.green("The WhaTap Connection is open: " + host + ":" + port + " pcode=" + this.secuMaster.PCODE + " oid=" + this.secuMaster.OID + " oname=" + System.getProperty("whatap.oname")));
            }
            connection_localport = conn.getLocalPort();
            lastReceiveTime = last_connected_time = System.currentTimeMillis();
            return true;
        }
        catch (Throwable e) {
            connection_localport = 0;
            Logger.println("TcpOpen", 5, e.getMessage() + " " + host + ":" + port, e);
            this.close();
            return false;
        }
    }

    private void prepareAutoOnameByServer(DataInputX in, DataOutputX out, String localAddr) throws Throwable {
        try {
            String auto_oname_prefix = this.conf.auto_oname_prefix;
            if (auto_oname_prefix.indexOf("{") >= 0) {
                OidUtil ou = new OidUtil();
                ou.setIp(localAddr);
                ou.setHostName(SysJMX.getHostName());
                ou.setCmd(System.getProperty("sun.java.command"));
                auto_oname_prefix = ou.mkOname(this.conf.auto_oname_prefix);
            }
            DataOutputX pout = new DataOutputX();
            pout.writeText(auto_oname_prefix);
            pout.writeInt(IPUtil.toInt(localAddr));
            byte[] msg = pout.toByteArray();
            if (this.conf.cypher_level > 0) {
                msg = this.secuMaster.cypher.encrypt(msg);
            }
            int trkey = 0;
            if (this.conf.cypher_level == 128) {
                if (this.conf.cypher_level == 0) {
                    trkey = 0;
                } else {
                    byte b0 = 1;
                    byte b1 = (byte)(this.conf.cypher_level / 8);
                    trkey = DataInputX.toInt(new byte[]{b0, b1, 0, 0}, 0);
                }
            }
            out.writeByte(1);
            out.writeByte(-4);
            out.writeLong(this.secuMaster.PCODE);
            out.writeInt(0);
            out.writeInt(trkey);
            out.writeIntBytes(msg);
            out.flush();
            byte source = in.readByte();
            byte code = in.readByte();
            long pcode = in.readLong();
            long oid = in.readInt();
            int transfer_key = in.readInt();
            byte[] data = in.readIntBytes(0x800000);
            if (this.conf.cypher_level > 0) {
                data = this.secuMaster.cypher.decrypt(data, 0, data.length);
            }
            String oname = new DataInputX(data).readText();
            System.setProperty("whatap.oname", oname);
            System.setProperty("whatap.autoname", "true");
            Logger.info("TcpPre", "AUTO ONAME : " + oname);
        }
        catch (DataIOException e) {
            throw e.getCause();
        }
    }

    private short prepareSysIdByServer(DataInputX in, DataOutputX out) throws Throwable {
        try {
            byte[] msg = new byte[]{};
            int trkey = 0;
            if (this.conf.cypher_level == 128) {
                if (this.conf.cypher_level == 0) {
                    trkey = 0;
                } else {
                    byte b0 = 1;
                    byte b1 = (byte)(this.conf.cypher_level / 8);
                    trkey = DataInputX.toInt(new byte[]{b0, b1, 0, 0}, 0);
                }
            }
            out.writeByte(1);
            out.writeByte(-7);
            out.writeLong(this.secuMaster.PCODE);
            out.writeInt(0);
            out.writeInt(trkey);
            out.writeIntBytes(msg);
            out.flush();
            byte source = in.readByte();
            byte code = in.readByte();
            long pcode = in.readLong();
            long oid = in.readInt();
            int transfer_key = in.readInt();
            byte[] data = in.readIntBytes(0x800000);
            short sysid = (short)new DataInputX(data).readInt();
            if (sysid > 0) {
                System.setProperty("whatap.sysid", String.valueOf(sysid));
                Logger.yellow("TcpInit", "sysid=" + sysid);
            } else {
                Logger.yellow("TcpInit", "sysid=" + sysid + " fail...");
            }
            this.secuMaster.resetWsid(sysid);
            return sysid;
        }
        catch (DataIOException e) {
            throw e.getCause();
        }
    }

    public void waitForConnection() {
        while (!this.isOpen()) {
            ThreadUtil.sleep(100L);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        conf = Configure.getInstance();
        block2: while (true) {
            if (conf.shutdown) {
                if (this.isOpen()) {
                    this.close();
                }
                ThreadUtil.sleep(5000L);
                continue;
            }
            for (i = 0; i < 5 && !this.isOpen(); ++i) {
                if (this.open()) continue;
                ThreadUtil.sleep(1000L);
            }
            for (i = 0; i < 30 && !this.isOpen(); ++i) {
                if (this.open()) continue;
                ThreadUtil.sleep(5000L);
            }
            while (!this.isOpen()) {
                if (this.open()) continue;
                ThreadUtil.sleep(30000L);
            }
            TcpSession.auto_oname_reset = conf.auto_oname_reset;
            TcpSession.whatap_name_reset = conf.whatap_name_reset;
            while (true) {
                if (this.isOpen() && !conf.shutdown) ** break;
                continue block2;
                ThreadUtil.sleep(5000L);
                if (conf.auto_oname_reset != TcpSession.auto_oname_reset) {
                    if (Configure.getInstance().auto_oname_enabled) {
                        try {
                            System.clearProperty("whatap.oname");
                        }
                        catch (Throwable var2_3) {
                            // empty catch block
                        }
                    }
                    this.close();
                }
                if (TcpSession.whatap_name_reset == conf.whatap_name_reset) continue;
                this.close();
            }
            break;
        }
    }

    protected byte[] readKeyReset(DataInputX in) {
        byte source = in.readByte();
        byte code = in.readByte();
        long pcode = in.readLong();
        long oid = in.readInt();
        int transfer_key = in.readInt();
        byte[] data = in.readIntBytes(1024);
        if (pcode != SecurityMaster.getInstance().PCODE || oid != (long)SecurityMaster.getInstance().OID) {
            return null;
        }
        return data;
    }

    protected byte[] keyReset() {
        Configure conf = Configure.getInstance();
        SecurityMaster secu = SecurityMaster.getInstance();
        byte[] msg = new DataOutputX().writeText("hello").writeText(secu.ONAME).writeInt(secu.IP).toByteArray();
        if (conf.cypher_level > 0) {
            msg = secu.cypher.encrypt(msg);
        }
        DataOutputX out = new DataOutputX();
        out.writeByte(1);
        int trkey = 0;
        if (conf.cypher_level == 128) {
            out.writeByte(-1);
        } else {
            out.writeByte(-3);
            if (conf.cypher_level == 0) {
                trkey = 0;
            } else {
                byte b0 = 1;
                byte b1 = (byte)(conf.cypher_level / 8);
                trkey = DataInputX.toInt(new byte[]{b0, b1, 0, 0}, 0);
            }
        }
        out.writeLong(SecurityMaster.getInstance().PCODE);
        out.writeInt(SecurityMaster.getInstance().OID);
        out.writeInt(trkey);
        out.writeIntBytes(msg);
        out.flush();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(byte code, boolean flush, short packType, byte[] b) {
        try {
            if (this.dout == null) {
                return false;
            }
            DataOutputX out = new DataOutputX();
            out.writeByte(1);
            out.writeByte(code);
            out.writeLong(this.secuMaster.PCODE);
            out.writeInt(this.secuMaster.OID);
            out.writeInt(CypherConf.TRANSFER_KEY);
            out.writeIntBytes(b);
            Object object = this.sendLock;
            synchronized (object) {
                this.dout.write(out.toByteArray());
                if (flush) {
                    this.dout.flush();
                }
            }
            return true;
        }
        catch (OutOfMemoryError t) {
            Logger.println("TcpSend", 10, t.getMessage());
        }
        catch (Throwable t) {
            Logger.println("TcpSend", 10, t);
        }
        this.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendOneWay(long pcode, byte[] b, boolean flush) {
        try {
            if (this.dout == null) {
                return false;
            }
            DataOutputX out = new DataOutputX();
            out.writeByte(10);
            out.writeByte(0);
            out.writeLong(pcode);
            out.writeLong(this.conf.accessKeyHash);
            out.writeIntBytes(b);
            Object object = this.sendLock;
            synchronized (object) {
                this.dout.write(out.toByteArray());
                if (flush) {
                    this.dout.flush();
                }
            }
            return true;
        }
        catch (Throwable t) {
            Logger.println("TcpOneWay", 10, t);
            this.close();
            return false;
        }
    }

    public static long getLastRecvTime() {
        return System.currentTimeMillis() - lastReceiveTime;
    }

    public TcpReturn read() {
        try {
            if (this.din == null) {
                ThreadUtil.sleep(10L);
                return empty;
            }
            TcpReturn out = new TcpReturn();
            byte source = this.din.readByte();
            out.code = this.din.readByte();
            long pcode = this.din.readLong();
            long oid = this.din.readInt();
            out.transfer_key = this.din.readInt();
            out.data = this.din.readIntBytes(0x800000);
            lastReceiveTime = System.currentTimeMillis();
            if (pcode != this.secuMaster.PCODE || oid != (long)this.secuMaster.OID) {
                return empty;
            }
            return out;
        }
        catch (DataIOException e) {
            Throwable c = e.getCause();
            if (c == null) {
                Logger.println("TcpRead", 5, "read " + e);
            } else if (c instanceof IOException) {
                Logger.println("TcpRead", 5, "read " + c + " recvtime=" + TcpSession.getLastRecvTime());
            } else {
                Logger.println("TcpRead", 5, "read " + c, c);
            }
        }
        catch (Throwable t) {
            Logger.println("TcpRead", 5, "read ", t);
        }
        this.close();
        return empty;
    }

    static {
        last_connected_time = 0L;
        okMacAddress = !SystemUtil.IS_JAVA_1_4 && !SystemUtil.IS_JAVA_1_5;
        auto_oname_reset = Configure.getInstance().auto_oname_reset;
        whatap_name_reset = Configure.getInstance().whatap_name_reset;
        lastReceiveTime = System.currentTimeMillis();
        empty = new TcpReturn();
    }
}

