/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.FileUtil;

public class TcpReqClientProxy {
    private String msg;
    private boolean failConLog;
    protected Socket socket = null;
    protected DataInputX din = null;
    protected DataOutputX dout = null;
    protected static final int READ_MAX = 0x800000;
    protected Configure conf = Configure.getInstance();
    private InetAddress localAddress;

    public TcpReqClientProxy(String msg) {
        this(msg, true);
    }

    public TcpReqClientProxy(String msg, boolean failConLog) {
        this.msg = msg;
        this.failConLog = failConLog;
    }

    public void close() {
        FileUtil.close(this.din);
        FileUtil.close(this.dout);
        FileUtil.close(this.socket);
        this.socket = null;
        this.din = null;
        this.dout = null;
    }

    public boolean isOpen() {
        return this.socket != null;
    }

    public boolean send(byte[] b) {
        try {
            if (this.dout == null) {
                return false;
            }
            this.dout.writeShort(51966);
            this.dout.writeIntBytes(b);
            this.dout.flush();
            return true;
        }
        catch (Throwable t) {
            Logger.println("TcpReqClientProxy", -1, this.msg + " " + t);
            return false;
        }
    }

    public byte[] read() {
        try {
            if (this.din == null) {
                return null;
            }
            if (this.din.readUnsignedShort() == 51966) {
                return this.din.readIntBytes(0x800000);
            }
            Logger.println("TcpReqClientProxy", 10, "Maybe broken data protocol(0xCAFE err)");
        }
        catch (Throwable t) {
            Logger.println("TcpReqClientProxy", -1, this.msg + " " + t);
        }
        this.close();
        return null;
    }

    public String getLocalAddress() {
        if (this.localAddress == null) {
            return "0.0.0.0";
        }
        return this.localAddress.getHostAddress();
    }

    public boolean open(String host, int port) {
        Socket conn = new Socket();
        try {
            conn.connect(new InetSocketAddress(host, port), 3000);
            conn.setSoTimeout(8000);
            this.localAddress = conn.getLocalAddress();
            DataInputX in = new DataInputX(new BufferedInputStream(conn.getInputStream()));
            DataOutputX out = new DataOutputX(new BufferedOutputStream(conn.getOutputStream()));
            this.din = in;
            this.dout = out;
            this.socket = conn;
            return true;
        }
        catch (Throwable e) {
            if (this.failConLog) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.msg).append(" ").append(host).append(":").append(port).append(" ").append(e.getMessage());
                Logger.println("TcpReqClient", -1, sb.toString());
            }
            return false;
        }
    }
}

