/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import whatap.agent.Configure;
import whatap.io.DataIOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.WsKey;
import whatap.util.FileUtil;

public class GetSysIdWithNewTCP {
    static final int READ_MAX = 0x800000;
    static long last_call;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short requestForSysId(int wsid, short platform, int oid) throws Throwable {
        short s;
        long now = System.currentTimeMillis();
        if (now - last_call < 5000L) {
            return 0;
        }
        last_call = now;
        Configure conf = Configure.getInstance();
        String host = conf.getWhatapServerHost();
        int port = conf.whatap_server_port;
        int connection_timeout = conf.tcp_connection_timeout;
        Socket conn = new Socket();
        DataInputX in = null;
        DataOutputX out = null;
        try {
            short sysid;
            conn.connect(new InetSocketAddress(InetAddress.getByName(host), port), connection_timeout);
            in = new DataInputX(new BufferedInputStream(conn.getInputStream()));
            out = new DataOutputX(new BufferedOutputStream(conn.getOutputStream()));
            conn.setSoTimeout(8000);
            s = sysid = GetSysIdWithNewTCP.prepareSysIdByServer(wsid, platform, oid, in, out);
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            FileUtil.close(out);
            FileUtil.close(conn);
            throw throwable;
        }
        FileUtil.close(in);
        FileUtil.close(out);
        FileUtil.close(conn);
        return s;
    }

    static short prepareSysIdByServer(int wsid, short platform, int oid, DataInputX in, DataOutputX out) throws Throwable {
        try {
            long pcode = new WsKey(wsid, platform, 0).toLongPcode();
            int trkey = 0;
            out.writeByte(1);
            out.writeByte(-7);
            out.writeLong(pcode);
            out.writeInt(oid);
            out.writeInt(trkey);
            out.writeIntBytes(new byte[0]);
            out.flush();
            byte source = in.readByte();
            byte code = in.readByte();
            pcode = in.readLong();
            oid = in.readInt();
            int transfer_key = in.readInt();
            byte[] data = in.readIntBytes(0x800000);
            return (short)new DataInputX(data).readInt();
        }
        catch (DataIOException e) {
            throw e.getCause();
        }
    }
}

