/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import whatap.agent.Configure;
import whatap.agent.jdbc.WrResultSet;
import whatap.agent.trace.LocalContext;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.TraceSQL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrStatement
implements Statement {
    Statement inner;
    Connection conn;
    Configure conf = Configure.getInstance();

    public WrStatement(Connection conn, Statement inner) {
        this.conn = conn;
        this.inner = inner;
    }

    @Override
    public final void close() throws SQLException {
        this.inner.close();
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.inner.getConnection();
    }

    @Override
    public final boolean execute(String sql, int[] a1) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            boolean r = this.inner.execute(sql, a1);
            return TraceSQL.execute(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final boolean execute(String sql, String[] a1) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            boolean r = this.inner.execute(sql, a1);
            return TraceSQL.execute(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final boolean execute(String sql, int a1) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            boolean r = this.inner.execute(sql, a1);
            return TraceSQL.execute(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            boolean r = this.inner.execute(sql);
            return TraceSQL.execute(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        Object stat = null;
        try {
            TraceContext ctx;
            LocalContext lCtx;
            stat = TraceSQL.start((Object)this.inner, sql);
            ResultSet rs = this.inner.executeQuery(sql);
            TraceSQL.executeQuery(rs, stat);
            if (this.conf.trace_rs_wrap_enabled && !(rs instanceof WrResultSet) && (lCtx = (LocalContext)stat) != null && (ctx = lCtx.context) != null && ctx.executed_sqlhash != 0) {
                return new WrResultSet(rs, ctx.executed_sqlhash, ctx.executed_dbc);
            }
            return rs;
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final int executeUpdate(String sql, String[] a1) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            int r = this.inner.executeUpdate(sql, a1);
            return TraceSQL.executeUpdate(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final int executeUpdate(String sql, int a1) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            int r = this.inner.executeUpdate(sql, a1);
            return TraceSQL.executeUpdate(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            int r = this.inner.executeUpdate(sql);
            return TraceSQL.executeUpdate(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final int executeUpdate(String sql, int[] a1) throws SQLException {
        Object stat = null;
        try {
            stat = TraceSQL.start((Object)this.inner, sql);
            int r = this.inner.executeUpdate(sql, a1);
            return TraceSQL.executeUpdate(r, stat);
        }
        catch (SQLException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (RuntimeException e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Error e) {
            TraceSQL.end(stat, e);
            throw e;
        }
        catch (Throwable e) {
            TraceSQL.end(stat, e);
            throw new SQLException(e);
        }
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.inner.getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(int a0) throws SQLException {
        this.inner.setMaxFieldSize(a0);
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.inner.getMaxRows();
    }

    @Override
    public final void setMaxRows(int a0) throws SQLException {
        this.inner.setMaxRows(a0);
    }

    @Override
    public final void setEscapeProcessing(boolean a0) throws SQLException {
        this.inner.setEscapeProcessing(a0);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.inner.getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int a0) throws SQLException {
        this.inner.setQueryTimeout(a0);
    }

    @Override
    public final void cancel() throws SQLException {
        this.inner.cancel();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.inner.getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.inner.clearWarnings();
    }

    @Override
    public final void setCursorName(String a0) throws SQLException {
        this.inner.setCursorName(a0);
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        TraceContext ctx;
        ResultSet rs = this.inner.getResultSet();
        if (this.conf.trace_rs_wrap_enabled && !(rs instanceof WrResultSet) && (ctx = TraceContextManager.getLocalContext()) != null && ctx.executed_sqlhash != 0) {
            return new WrResultSet(rs, ctx.executed_sqlhash, ctx.executed_dbc);
        }
        return rs;
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        return TraceSQL.updateCount(this.inner.getUpdateCount(), this.inner);
    }

    @Override
    public final boolean getMoreResults(int a0) throws SQLException {
        return this.inner.getMoreResults(a0);
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.inner.getMoreResults();
    }

    @Override
    public final void setFetchDirection(int a0) throws SQLException {
        this.inner.setFetchDirection(a0);
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.inner.getFetchDirection();
    }

    @Override
    public final void setFetchSize(int a0) throws SQLException {
        this.inner.setFetchSize(a0);
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.inner.getFetchSize();
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.inner.getResultSetConcurrency();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.inner.getResultSetType();
    }

    @Override
    public final void addBatch(String a0) throws SQLException {
        this.inner.addBatch(a0);
    }

    @Override
    public final void clearBatch() throws SQLException {
        this.inner.clearBatch();
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        return this.inner.executeBatch();
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.inner.getGeneratedKeys();
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        return this.inner.getResultSetHoldability();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.inner.isClosed();
    }

    @Override
    public final void setPoolable(boolean a0) throws SQLException {
        this.inner.setPoolable(a0);
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return this.inner.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.inner.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.inner.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.inner.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.inner.isWrapperFor(iface);
    }
}

