/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import whatap.agent.Logger;
import whatap.agent.asm.util.AsmSQL;
import whatap.agent.conf.ConfDBC;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.DBType;
import whatap.agent.trace.sql.SID;
import whatap.util.IntKeyLinkedMap;

class DBSidUtil {
    private static String oracle = "select sid,serial#,USERENV('instance') inst_id from v$session where sid=USERENV('sid')";
    private static String pgsql = "select pg_backend_pid()";
    private static String mysql = "SELECT CONNECTION_ID()";
    private static String aws_mysql = "SELECT CONNECTION_ID()";
    private static String mssql = "SELECT @@SPID AS current_session_id";
    public static String fake = "select sid";
    static IntKeyLinkedMap<SID> hashTable = new IntKeyLinkedMap().setMax(1000);
    static long last_log = 0L;

    DBSidUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SID getSid(Connection c) {
        int conHash = DBSidUtil.getNativeHash(c);
        if (conHash == 0) {
            return null;
        }
        SID conSid = hashTable.get(conHash);
        if (conSid != null) {
            return conSid;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            ctx.jdbc_stmt_loading_sid = true;
            try {
                int dbtype = DBSidUtil.getNativeDBType(c);
                String sql4sid = DBSidUtil.getSqlForSid(dbtype);
                if (sql4sid == null) {
                    hashTable.put(conHash, new SID());
                    SID sID = null;
                    return sID;
                }
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = c.createStatement();
                    rs = stmt.executeQuery(sql4sid);
                    if (rs.next()) {
                        SID sid = new SID();
                        sid.dbtype = dbtype;
                        sid.sid = rs.getInt(1);
                        if (oracle == sql4sid) {
                            sid.serial = rs.getInt(2);
                            sid.inst = rs.getInt(3);
                        }
                        hashTable.put(conHash, sid);
                        SID sID = sid;
                        return sID;
                    }
                }
                catch (SQLException se) {
                    long now;
                    if (ConfDBC.debug_dbc_sid_enabled && (now = System.currentTimeMillis()) - last_log > 5000L) {
                        last_log = now;
                        Logger.println(sql4sid, se);
                    }
                    hashTable.put(conHash, new SID());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Exception e) {
                long now;
                if (ConfDBC.debug_dbc_sid_enabled && (now = System.currentTimeMillis()) - last_log > 5000L) {
                    last_log = now;
                    Logger.println(e.getMessage(), e);
                }
            }
            finally {
                ctx.jdbc_stmt_loading_sid = false;
            }
        }
        return null;
    }

    private static int getNativeDBType(Connection c) {
        try {
            String dbtype = c.nativeSQL(AsmSQL.whatap_dbtype);
            if (dbtype != null) {
                return Integer.parseInt(dbtype);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static int getNativeHash(Connection con) {
        try {
            Integer h;
            String ok = con.nativeSQL(AsmSQL.whatap);
            if (AsmSQL.ok == ok && (h = AsmSQL.conMap.get()) != null) {
                return h;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static String getSqlForSid(int dbtype) {
        switch (dbtype) {
            case 3: {
                return mysql;
            }
            case 1: {
                return oracle;
            }
            case 2: {
                return pgsql;
            }
            case 9: {
                return aws_mysql;
            }
            case 7: {
                return mssql;
            }
            case 8: {
                return fake;
            }
        }
        return null;
    }

    public static String getDBType(Connection conn) {
        int dbtype = DBSidUtil.getNativeDBType(conn);
        return DBType.getString(dbtype);
    }
}

