/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi.trace;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.MeterHTTPC;
import whatap.agent.data.DataTextAgent;
import whatap.agent.instrumentation.rmi.trace.RmiContextPayload;
import whatap.agent.stat.StatHttpc;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.HttpcContext;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceHttpc;
import whatap.io.DataInputX;
import whatap.lang.step.HttpcStepX;
import whatap.lang.step.MessageStep;
import whatap.util.HashUtil;
import whatap.util.IPUtil;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.SysJMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiTraceHelper {
    private static volatile Field UNICAST_REF_FIELD = null;
    private static volatile Field LIVE_REF_EP_FIELD = null;
    private static volatile Field ENDPOINT_HOST_FIELD = null;
    private static volatile Field ENDPOINT_PORT_FIELD = null;
    private static final StringKeyLinkedMap<String> INTERFACE_CACHE = new StringKeyLinkedMap().setMax(1000);

    static HttpcContext createHttpcStep(TraceContext ctx, Method method, Object unicastRef, ThreadLocal<RmiContextPayload> clientContext) {
        String rmiUrl;
        Configure conf = Configure.getInstance();
        if (!conf.httpc_enabled || ctx.active_httpc_hash != 0) {
            return null;
        }
        TraceHttpc.setRatedMtraceKey(ctx);
        HttpcStepX step = new HttpcStepX();
        step.stepId = TraceContext.getNextCallerStepId();
        step.start_time = ctx.getElapsedTime();
        step.driver = "RMI";
        ctx.httpc_url = rmiUrl = RmiTraceHelper.buildClientUrl(method);
        step.url = HashUtil.hash(rmiUrl);
        DataTextAgent.HTTPC_URL.add(step.url, rmiUrl);
        RmiTraceHelper.extractHostPort(unicastRef, ctx, step);
        if (ConfTrace.trace_httpc_resource_enabled) {
            if (conf.trace_cpu_step_enabled) {
                step.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - ctx.start_cpu);
            }
            if (conf.trace_malloc_step_enabled) {
                step.start_mem = (int)(SysJMX.getCurrentThreadAllocBytes() - ctx.start_malloc);
            }
        }
        ctx.profile.push(step);
        ctx.active_httpc_hash = step.url;
        ctx.httpc_stime = step.start_time;
        RmiContextPayload payload = RmiContextPayload.fromTraceContext(ctx, step.stepId);
        clientContext.set(payload);
        HookArgs hookPoint = new HookArgs("sun/rmi/server/UnicastRef", "invoke", "(Ljava/rmi/Remote;Ljava/lang/reflect/Method;[Ljava/lang/Object;J)Ljava/lang/Object;", unicastRef, null);
        return new HttpcContext(ctx, step, hookPoint, null);
    }

    static void finishHttpcStep(HttpcContext httpcCtx, Throwable thr, ThreadLocal<RmiContextPayload> clientContext) {
        clientContext.remove();
        if (httpcCtx == null || httpcCtx.context == null || httpcCtx.step == null) {
            return;
        }
        TraceContext ctx = httpcCtx.context;
        HttpcStepX step = (HttpcStepX)httpcCtx.step;
        step.elapsed = ctx.getElapsedTime() - step.start_time;
        if (thr != null) {
            TraceHttpc.handleHttpcExceptionError(ctx, step, thr);
        } else if (step.error == 0L && step.elapsed > ConfTrace.trace_error_httpc_time_max) {
            TraceHttpc.handleHttpcSlowError(ctx, step);
        }
        MeterHTTPC.getInstance().add(step.host, step.elapsed, step.error != 0L);
        StatHttpc.getInstance().addHttpcTime(ctx.service_hash, step.url, step.host, step.port, step.elapsed, step.error != 0L);
        ctx.active_httpc_hash = 0;
        ctx.httpc_url = null;
        ctx.httpc_host = null;
        ctx.httpc_host_hash = 0;
        ctx.httpc_stime = 0;
        ++ctx.httpc_count;
        ctx.httpc_time += step.elapsed;
        ctx.profile.pop(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void extractHostPort(Object unicastRef, TraceContext ctx, HttpcStepX step) {
        try {
            Object f;
            Object endpoint;
            Object f2;
            Object liveRef;
            Object f3;
            if (UNICAST_REF_FIELD == null) {
                Class<RmiTraceHelper> clazz = RmiTraceHelper.class;
                // MONITORENTER : whatap.agent.instrumentation.rmi.trace.RmiTraceHelper.class
                if (UNICAST_REF_FIELD == null) {
                    f3 = unicastRef.getClass().getDeclaredField("ref");
                    ((Field)f3).setAccessible(true);
                    UNICAST_REF_FIELD = f3;
                }
                // MONITOREXIT : clazz
            }
            if ((liveRef = UNICAST_REF_FIELD.get(unicastRef)) == null) {
                return;
            }
            if (LIVE_REF_EP_FIELD == null) {
                f3 = RmiTraceHelper.class;
                // MONITORENTER : whatap.agent.instrumentation.rmi.trace.RmiTraceHelper.class
                if (LIVE_REF_EP_FIELD == null) {
                    f2 = liveRef.getClass().getDeclaredField("ep");
                    ((Field)f2).setAccessible(true);
                    LIVE_REF_EP_FIELD = f2;
                }
                // MONITOREXIT : f3
            }
            if ((endpoint = LIVE_REF_EP_FIELD.get(liveRef)) == null) {
                return;
            }
            if (ENDPOINT_HOST_FIELD == null) {
                f2 = RmiTraceHelper.class;
                // MONITORENTER : whatap.agent.instrumentation.rmi.trace.RmiTraceHelper.class
                if (ENDPOINT_HOST_FIELD == null) {
                    f = endpoint.getClass().getDeclaredField("host");
                    ((Field)f).setAccessible(true);
                    ENDPOINT_HOST_FIELD = f;
                }
                // MONITOREXIT : f2
            }
            String host = (String)ENDPOINT_HOST_FIELD.get(endpoint);
            if (ENDPOINT_PORT_FIELD == null) {
                f = RmiTraceHelper.class;
                // MONITORENTER : whatap.agent.instrumentation.rmi.trace.RmiTraceHelper.class
                if (ENDPOINT_PORT_FIELD == null) {
                    Field f4 = endpoint.getClass().getDeclaredField("port");
                    f4.setAccessible(true);
                    ENDPOINT_PORT_FIELD = f4;
                }
                // MONITOREXIT : f
            }
            int port = ENDPOINT_PORT_FIELD.getInt(endpoint);
            ctx.httpc_host = host;
            ctx.httpc_port = port;
            if (host != null) {
                step.host = HashUtil.hash(host);
                DataTextAgent.HTTPC_HOST.add(step.host, host);
            }
            step.port = port;
            return;
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "Failed to extract host:port", t);
        }
    }

    static String buildServiceName(Object obj, String methodName) {
        if (obj == null) {
            return "[RMI] Unknown";
        }
        String interfaceName = RmiTraceHelper.getInterfaceSimpleName(obj);
        return "[RMI] " + interfaceName + "." + methodName;
    }

    private static String getInterfaceSimpleName(Object obj) {
        Class<?> clazz = obj.getClass();
        String className = clazz.getName();
        String cached = INTERFACE_CACHE.get(className);
        if (cached != null) {
            return cached;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        String interfaceName = interfaces.length > 0 ? interfaces[0].getSimpleName() : clazz.getSimpleName();
        INTERFACE_CACHE.put(className, interfaceName);
        return interfaceName;
    }

    static String buildClientUrl(Method method) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName();
    }

    static void extractClientIP(String threadName, TraceContext ctx) {
        if (threadName == null || !threadName.startsWith("RMI TCP Connection")) {
            return;
        }
        int dashIndex = threadName.lastIndexOf(45);
        if (dashIndex <= 0 || dashIndex >= threadName.length() - 1) {
            return;
        }
        ctx.remoteAddr = threadName.substring(dashIndex + 1);
        if (ConfTrace.trace_remote_ip6_enabled && ctx.remoteAddr.indexOf(58) >= 0) {
            ctx.remoteAddrIPv6 = true;
        } else {
            ctx.remoteIp = DataInputX.toInt(IPUtil.toBytes(ctx.remoteAddr), 0);
        }
    }

    static void traceRmiHeader(TraceContext ctx, RmiContextPayload payload) {
        if (payload == null || payload.keys().isEmpty()) {
            return;
        }
        int hash = HashUtil.hash("RMI-HEADERS");
        DataTextAgent.MESSAGE.add(hash, "RMI-HEADERS");
        MessageStep step = new MessageStep();
        step.hash = hash;
        StringBuilder vb = new StringBuilder();
        for (String key : payload.keys()) {
            vb.append(key).append("=");
            if (!ConfTrace.trace_rmi_header_ignore_keys.hasKey(key)) {
                vb.append(StringUtil.limiting(payload.get(key), 1024)).append("\n");
                continue;
            }
            vb.append("#\n");
        }
        step.desc = vb.toString();
        ctx.profile.add(step);
    }
}

