/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi.trace;

import java.lang.reflect.Method;
import whatap.agent.Logger;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataTextAgent;
import whatap.agent.instrumentation.rmi.trace.RmiContextPayload;
import whatap.agent.instrumentation.rmi.trace.RmiTraceHelper;
import whatap.agent.trace.HttpcContext;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.step.MethodStepX;
import whatap.util.HashUtil;

public class RmiTrace {
    private static final ThreadLocal<RmiContextPayload> clientContext = new ThreadLocal();

    public static Object startInvoke(Object remote, Object method, Object args, Object unicastRef) {
        try {
            if (!ConfTrace.trace_rmi_enabled) {
                return null;
            }
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return null;
            }
            if (method instanceof Method) {
                HttpcContext httpcCtx = RmiTraceHelper.createHttpcStep(ctx, (Method)method, unicastRef, clientContext);
                return httpcCtx;
            }
            return null;
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "beforeInvoke failed", t);
            return null;
        }
    }

    public static void endInvoke(Object context, Object returnValue, Throwable thr) {
        try {
            if (context instanceof HttpcContext) {
                HttpcContext httpcCtx = (HttpcContext)context;
                RmiTraceHelper.finishHttpcStep(httpcCtx, thr, clientContext);
            }
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "afterInvoke failed", t);
        }
    }

    public static RmiContextPayload getClientContext() {
        if (!ConfTrace.trace_rmi_enabled) {
            return null;
        }
        return clientContext.get();
    }

    public static Object startDispatch(Object obj, Object call) {
        try {
            if (!ConfTrace.trace_rmi_enabled) {
                return null;
            }
            if (obj == null) {
                return null;
            }
            String className = obj.getClass().getName();
            if (className.equals("sun.rmi.transport.DGCImpl") || className.equals("sun.rmi.registry.RegistryImpl")) {
                return null;
            }
            Class<?>[] interfaces = obj.getClass().getInterfaces();
            String serviceName = interfaces.length > 0 ? "[RMI] " + interfaces[0].getSimpleName() : "[RMI] " + obj.getClass().getSimpleName();
            TraceContext ctx = TxTrace.startTx(serviceName, "sun/rmi/server/UnicastServerRef", "dispatch", "(Ljava/rmi/Remote;Ljava/rmi/server/RemoteCall;)V", obj, new Object[]{obj, call});
            if (ctx != null) {
                String threadName = Thread.currentThread().getName();
                RmiTraceHelper.extractClientIP(threadName, ctx);
            }
            return ctx;
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "beforeDispatch failed", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endDispatch(Object context, Object returnValue, Throwable thr) {
        try {
            if (!ConfTrace.trace_rmi_enabled) {
                return;
            }
            if (context instanceof TraceContext) {
                TraceContext ctx = (TraceContext)context;
                RmiContextPayload payload = RmiContextPayload.get();
                if (payload != null) {
                    payload.applyToTraceContext(ctx);
                }
                TxTrace.endTx(ctx, thr);
            }
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "afterDispatch failed", t);
        }
        finally {
            RmiContextPayload.remove();
        }
    }

    public static Object startRemoteMethod(Object target, String methodName, String methodDesc, String stringParam) {
        try {
            RmiContextPayload payload;
            if (!ConfTrace.trace_rmi_enabled) {
                return null;
            }
            TraceContext existingCtx = TraceContextManager.getLocalContext();
            if (existingCtx == null) {
                return null;
            }
            String targetClassName = target.getClass().getName();
            String fullMethodName = targetClassName + "." + methodName + methodDesc;
            String serviceName = RmiTraceHelper.buildServiceName(target, methodName);
            if (methodName.startsWith("__WL_")) {
                return null;
            }
            if (existingCtx.service_name != null && existingCtx.service_name.startsWith("[RMI]")) {
                existingCtx.service_name = serviceName;
                existingCtx.service_hash = HashUtil.hash(serviceName);
            }
            if (ConfTrace.trace_rmi_header_enabled && (payload = RmiContextPayload.get()) != null) {
                RmiTraceHelper.traceRmiHeader(existingCtx, payload);
            }
            if (!ConfTrace.trace_rmi_server_method_enabled) {
                return null;
            }
            int methodHash = HashUtil.hash(fullMethodName);
            DataTextAgent.METHOD.add(methodHash, fullMethodName);
            MethodStepX step = new MethodStepX();
            step.hash = methodHash;
            step.start_time = existingCtx.getElapsedTime();
            existingCtx.profile.push(step);
            return step;
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "beforeRemoteMethod failed", t);
            return null;
        }
    }

    public static void endRemoteMethod(Object context, Object returnValue, Throwable thr) {
        try {
            if (!ConfTrace.trace_rmi_enabled) {
                return;
            }
            if (context instanceof MethodStepX) {
                MethodStepX step = (MethodStepX)context;
                TraceContext ctx = TraceContextManager.getLocalContext();
                if (ctx != null) {
                    step.elapsed = ctx.getElapsedTime() - step.start_time;
                    if (thr != null) {
                        step.exception = thr.getClass().getName();
                    }
                    ctx.profile.pop(step);
                }
            }
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "endRemoteMethod failed", t);
        }
    }
}

