/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi.trace;

import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.server.ObjID;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.transport.Connection;
import sun.rmi.transport.StreamRemoteCall;
import whatap.agent.Logger;
import whatap.agent.conf.ConfTrace;
import whatap.agent.instrumentation.rmi.trace.RmiConstants;
import whatap.agent.instrumentation.rmi.trace.RmiContextPayload;
import whatap.agent.instrumentation.rmi.trace.RmiTrace;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;

public class RmiContextPropagator {
    private static final Map<Connection, Boolean> KNOWN_CONNECTIONS = Collections.synchronizedMap(new WeakHashMap());
    private static final ObjID ACTIVATOR_ID = new ObjID(1);
    private static final ObjID DGC_ID = new ObjID(2);
    private static final ObjID REGISTRY_ID = new ObjID(0);

    public static boolean isRmiInternalObject(ObjID id) {
        return ACTIVATOR_ID.equals(id) || DGC_ID.equals(id) || REGISTRY_ID.equals(id);
    }

    private static boolean isReusable(Connection conn) {
        try {
            Method isReusableMethod = conn.getClass().getMethod("isReusable", new Class[0]);
            return (Boolean)isReusableMethod.invoke((Object)conn, new Object[0]);
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "Failed to check isReusable", t);
            return true;
        }
    }

    public static void propagateContext(Connection conn) {
        try {
            if (!ConfTrace.trace_rmi_enabled) {
                return;
            }
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null || ctx.active_httpc_hash == 0) {
                return;
            }
            if (!RmiContextPropagator.isReusable(conn)) {
                return;
            }
            Boolean cachedResult = KNOWN_CONNECTIONS.get(conn);
            if (cachedResult != null) {
                if (!cachedResult.booleanValue()) {
                    return;
                }
                RmiContextPayload payload = RmiTrace.getClientContext();
                if (payload == null) {
                    return;
                }
                RmiContextPropagator.sendContextPayload(conn, payload);
                return;
            }
            if (!RmiContextPropagator.sendContextCheck(conn)) {
                KNOWN_CONNECTIONS.put(conn, Boolean.FALSE);
                return;
            }
            KNOWN_CONNECTIONS.put(conn, Boolean.TRUE);
            RmiContextPayload payload = RmiTrace.getClientContext();
            if (payload == null) {
                return;
            }
            RmiContextPropagator.sendContextPayload(conn, payload);
        }
        catch (Throwable t) {
            Logger.println("RMI", 30, "Context propagation failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendContextCheck(Connection conn) {
        StreamRemoteCall call = null;
        try {
            call = new StreamRemoteCall(conn);
            conn.getOutputStream().write(80);
            ObjectOutput out = call.getOutputStream();
            RmiConstants.CONTEXT_OBJ_ID.write(out);
            out.writeInt(-1);
            out.writeLong(-1L);
            call.executeCall();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Exception serverEx;
            if (call != null && (serverEx = call.getServerException()) instanceof NoSuchObjectException) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (call != null) {
                try {
                    call.done();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendContextPayload(Connection conn, RmiContextPayload payload) {
        StreamRemoteCall call = null;
        try {
            call = new StreamRemoteCall(conn);
            conn.getOutputStream().write(80);
            ObjectOutput out = call.getOutputStream();
            RmiConstants.CONTEXT_OBJ_ID.write(out);
            out.writeInt(-2);
            out.writeLong(-2L);
            payload.write(out);
            call.executeCall();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.println("RMI", 30, "Context payload propagation failed", e);
        }
        finally {
            if (call != null) {
                try {
                    call.done();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

