/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi.trace;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.trace.TraceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiContextPayload
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final ThreadLocal<RmiContextPayload> payloadHolder = new ThreadLocal();
    private final Map<String, String> headers;

    public RmiContextPayload() {
        this.headers = new HashMap<String, String>(8, 1.0f);
    }

    public RmiContextPayload(Map<String, String> headers) {
        this.headers = headers != null ? new HashMap<String, String>(headers) : new HashMap();
    }

    public static RmiContextPayload fromTraceContext(TraceContext ctx, long stepId) {
        String traceparent;
        String mst;
        String spec;
        if (ctx == null) {
            return null;
        }
        RmiContextPayload payload = new RmiContextPayload();
        String poid = TraceContext.transferPOID();
        if (poid != null) {
            payload.put(ConfMTrace._trace_mtrace_poid_key, poid);
        }
        if (ConfMTrace.stat_mtrace_enabled && (spec = ctx.transferSPEC_URL1()) != null) {
            payload.put(ConfMTrace._trace_mtrace_spec_key1, spec);
        }
        if (ConfMTrace.mtid_mtrace_enabled && ctx.mtid != 0L && (mst = ctx.transferMTID_CALLERTX(stepId)) != null) {
            payload.put(ConfMTrace._trace_mtrace_caller_key, mst);
        }
        if (ConfMTrace.mtrace_traceparent_enabled && (traceparent = ctx.trasferMTID_TRACEPARENT(stepId)) != null) {
            payload.put(ConfMTrace._trace_mtrace_traceparent_key, traceparent);
        }
        return payload;
    }

    public void applyToTraceContext(TraceContext ctx) {
        String traceparent;
        String spec;
        String mst;
        if (ctx == null || this.headers == null || this.headers.isEmpty()) {
            return;
        }
        String poid = this.headers.get(ConfMTrace._trace_mtrace_poid_key);
        if (poid != null && poid.length() > 0) {
            ctx.setCallerPOID(poid);
        }
        if ((mst = this.headers.get(ConfMTrace._trace_mtrace_caller_key)) != null && mst.length() > 0) {
            ctx.setTransferMTID_CALLERTX(mst);
        }
        if ((spec = this.headers.get(ConfMTrace._trace_mtrace_spec_key1)) != null && spec.length() > 0) {
            ctx.setTransferSPEC_URL1(spec);
        }
        if ((traceparent = this.headers.get(ConfMTrace._trace_mtrace_traceparent_key)) != null && traceparent.length() > 0) {
            ctx.mcallerTraceparentValue = traceparent;
        }
    }

    public static void set(RmiContextPayload payload) {
        payloadHolder.set(payload);
    }

    public static RmiContextPayload get() {
        return payloadHolder.get();
    }

    public static void remove() {
        payloadHolder.remove();
    }

    public void put(String key, String value) {
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
    }

    public String get(String key) {
        return this.headers.get(key);
    }

    public Set<String> keys() {
        return this.headers.keySet();
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public void write(ObjectOutput out) throws IOException {
        try {
            out.writeObject(this.headers);
        }
        catch (IOException e) {
            Logger.println("RMI", 30, "RmiContextPayload serialization failed", e);
            throw e;
        }
    }

    public static RmiContextPayload read(ObjectInput in) throws IOException {
        try {
            Object object = in.readObject();
            if (object instanceof Map) {
                Map map = (Map)object;
                return new RmiContextPayload(map);
            }
            return null;
        }
        catch (ClassCastException ex) {
            Logger.println("RMI", 30, "RmiContextPayload deserialization failed (ClassCastException)", ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.println("RMI", 30, "RmiContextPayload deserialization failed (ClassNotFoundException)", ex);
        }
        return null;
    }

    public String toString() {
        return "RmiContextPayload{headers=" + this.headers + "}";
    }
}

