/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi.trace;

import java.io.IOException;
import java.io.ObjectInput;
import java.rmi.Remote;
import java.rmi.server.RemoteCall;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.Target;
import whatap.agent.Logger;
import whatap.agent.instrumentation.rmi.trace.RmiConstants;
import whatap.agent.instrumentation.rmi.trace.RmiContextPayload;

public class RmiContextDispatcher
implements Dispatcher {
    private static final NoopRemote NOOP_REMOTE = new NoopRemote();

    public static Target createContextTarget() {
        try {
            return new Target(NOOP_REMOTE, new RmiContextDispatcher(), null, RmiConstants.CONTEXT_OBJ_ID, false);
        }
        catch (Throwable t) {
            Logger.println("RMI-SERVER", "Failed to create context target: " + t);
            return null;
        }
    }

    public static Target interceptTarget(Object objectEndpoint, Target original) {
        try {
            if (objectEndpoint == null) {
                return original;
            }
            String objIdStr = objectEndpoint.toString();
            if (objIdStr == null) {
                return original;
            }
            if (RmiContextDispatcher.isContextObjId(objIdStr)) {
                return RmiContextDispatcher.createContextTarget();
            }
            return original;
        }
        catch (Throwable t) {
            Logger.println("RMI", 0, "RmiContextDispatcher registration failed", t);
            return original;
        }
    }

    private static boolean isContextObjId(String objIdStr) {
        return RmiConstants.CONTEXT_OBJ_ID_STRING.equals(objIdStr);
    }

    public void dispatch(Remote obj, RemoteCall call) throws IOException {
        try {
            ObjectInput in = call.getInputStream();
            int op = in.readInt();
            in.readLong();
            if (op == -1) {
                call.releaseInputStream();
                call.getResultStream(true);
                call.releaseOutputStream();
            } else if (op == -2) {
                RmiContextPayload payload = RmiContextPayload.read(in);
                if (payload != null) {
                    RmiContextPayload.set(payload);
                }
                call.releaseInputStream();
                call.getResultStream(true);
                call.releaseOutputStream();
            } else {
                call.releaseInputStream();
                call.getResultStream(true);
                call.releaseOutputStream();
            }
        }
        catch (Throwable t) {
            Logger.println("RMI", 30, "RmiContextDispatcher.dispatch failed", t);
            try {
                call.releaseInputStream();
                call.getResultStream(false);
                call.releaseOutputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class NoopRemote
    implements Remote {
    }
}

