/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi;

import whatap.agent.AgentTransformer;
import whatap.agent.ClassDesc;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.instrumentation.rmi.RemoteTargetObjectCV;
import whatap.agent.instrumentation.rmi.RmiHierarchyChecker;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class RmiTargetObjectASM
extends IASM
implements Opcodes {
    public void reserved(ReservedSet classSet) {
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.implementsRemoteInterface(className, classDesc)) {
            return cv;
        }
        if (this.isJdkInternalRemote(className)) {
            return cv;
        }
        return new RemoteTargetObjectCV(cv, className);
    }

    private boolean implementsRemoteInterface(String className, ClassDesc classDesc) {
        if (classDesc == null || classDesc.interfaces == null || classDesc.interfaces.length == 0) {
            return false;
        }
        for (String interfaceName : classDesc.interfaces) {
            if ("java/rmi/Remote".equals(interfaceName)) {
                return true;
            }
            if (!"javax/ejb/EJBObject".equals(interfaceName) && !"javax/ejb/EJBHome".equals(interfaceName)) continue;
            return true;
        }
        try {
            ClassLoader loader = AgentTransformer.hookingCtx.get();
            return RmiHierarchyChecker.implementsInterface(className, "java/rmi/Remote", loader);
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "Hierarchy check failed for " + className, t);
            return false;
        }
    }

    private boolean isJdkInternalRemote(String className) {
        if (className.startsWith("whatap/")) {
            return true;
        }
        if (className.startsWith("sun/rmi/")) {
            return true;
        }
        if (className.startsWith("java/rmi/")) {
            return true;
        }
        if (className.startsWith("javax/rmi/")) {
            return true;
        }
        if (className.startsWith("com/sun/rmi/")) {
            return true;
        }
        if (className.startsWith("org/springframework/remoting")) {
            return true;
        }
        if (className.startsWith("weblogic/")) {
            return true;
        }
        return className.startsWith("org/omg/");
    }
}

