/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi;

import java.io.InputStream;
import whatap.agent.Logger;
import whatap.org.objectweb.asm.ClassReader;

public class RmiHierarchyChecker {
    public static boolean implementsInterface(String className, String targetInterface, ClassLoader loader) {
        try {
            ClassReader cr = RmiHierarchyChecker.getClassReader(className, loader);
            if (cr == null) {
                return false;
            }
            return RmiHierarchyChecker.checkInterfaceHierarchy(cr, targetInterface, loader);
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "Failed to check interface hierarchy", t);
            return false;
        }
    }

    private static boolean checkInterfaceHierarchy(ClassReader cr, String targetInterface, ClassLoader loader) {
        String[] interfaces = cr.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return false;
        }
        for (String iface : interfaces) {
            if (targetInterface.equals(iface)) {
                return true;
            }
            ClassReader parentCr = RmiHierarchyChecker.getClassReader(iface, loader);
            if (parentCr == null || !RmiHierarchyChecker.checkInterfaceHierarchy(parentCr, targetInterface, loader)) continue;
            return true;
        }
        return false;
    }

    private static ClassReader getClassReader(String className, ClassLoader loader) {
        try {
            InputStream is;
            String resourceName = className.replace('.', '/') + ".class";
            InputStream inputStream = is = loader != null ? loader.getResourceAsStream(resourceName) : ClassLoader.getSystemResourceAsStream(resourceName);
            if (is == null) {
                return null;
            }
            ClassReader cr = new ClassReader(is);
            is.close();
            return cr;
        }
        catch (Throwable t) {
            Logger.println("RMI", 10, "Failed to read class", t);
            return null;
        }
    }
}

