/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi;

import whatap.agent.asm.IASM;
import whatap.agent.instrumentation.rmi.ObjectTableGetTargetMV;
import whatap.agent.instrumentation.rmi.StreamRemoteCallConstructorMV;
import whatap.agent.instrumentation.rmi.UnicastRefInvokeMV;
import whatap.agent.instrumentation.rmi.UnicastServerRefDispatchMV;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;

class RmiCV
extends ClassVisitor
implements Opcodes {
    private final String className;
    private final String dotClassName;

    public RmiCV(ClassVisitor cv, String className) {
        super(IASM.API, cv);
        this.className = className;
        this.dotClassName = className.replace('/', '.');
    }

    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, methodName, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if ("sun.rmi.server.UnicastRef".equals(this.dotClassName) && "invoke".equals(methodName) && "(Ljava/rmi/Remote;Ljava/lang/reflect/Method;[Ljava/lang/Object;J)Ljava/lang/Object;".equals(desc)) {
            return new UnicastRefInvokeMV(mv, access, methodName, desc, this.className);
        }
        if ("sun.rmi.transport.StreamRemoteCall".equals(this.dotClassName) && "<init>".equals(methodName) && "(Lsun/rmi/transport/Connection;Ljava/rmi/server/ObjID;IJ)V".equals(desc)) {
            return new StreamRemoteCallConstructorMV(mv, access, desc, this.className);
        }
        if ("sun.rmi.transport.ObjectTable".equals(this.dotClassName) && "getTarget".equals(methodName) && "(Lsun/rmi/transport/ObjectEndpoint;)Lsun/rmi/transport/Target;".equals(desc) && this.isStatic(access)) {
            return new ObjectTableGetTargetMV(mv, access, methodName, desc, this.className);
        }
        if ("sun.rmi.server.UnicastServerRef".equals(this.dotClassName) && "dispatch".equals(methodName) && "(Ljava/rmi/Remote;Ljava/rmi/server/RemoteCall;)V".equals(desc)) {
            return new UnicastServerRefDispatchMV(mv, access, methodName, desc, this.className);
        }
        return mv;
    }

    private boolean isStatic(int access) {
        return (access & 8) != 0;
    }
}

