/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi;

import whatap.agent.asm.IASM;
import whatap.agent.conf.ConfInstrumentation;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.AdviceAdapter;

class RemoteTargetObjectMV
extends AdviceAdapter {
    private static final String TRACE_CLASS = "whatap/agent/instrumentation/rmi/trace/RmiTrace";
    private static final String START_METHOD = "startRemoteMethod";
    private static final String START_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;";
    private static final String END_METHOD = "endRemoteMethod";
    private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V";
    private final String className;
    private final String methodName;
    private final String methodDesc;
    private int contextVar;
    private final Type returnType;

    public RemoteTargetObjectMV(MethodVisitor mv, int access, String name, String desc, String className) {
        super(IASM.API, mv, access, name, desc);
        this.className = className;
        this.methodName = name;
        this.methodDesc = desc;
        this.returnType = Type.getReturnType(desc);
    }

    protected void onMethodEnter() {
        boolean extractString = ConfInstrumentation.instrumentation_rmi_capture_param_enabled;
        this.mv.visitVarInsn(25, 0);
        this.mv.visitLdcInsn(this.methodName);
        this.mv.visitLdcInsn(this.methodDesc);
        if (extractString) {
            this.extractFirstStringParameter();
        } else {
            this.mv.visitInsn(1);
        }
        this.mv.visitMethodInsn(184, TRACE_CLASS, START_METHOD, START_SIGNATURE, false);
        this.contextVar = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.contextVar);
    }

    private void extractFirstStringParameter() {
        Type[] argTypes = Type.getArgumentTypes(this.methodDesc);
        int localVarIndex = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            if (argType.getDescriptor().equals("Ljava/lang/String;")) {
                this.mv.visitVarInsn(25, localVarIndex);
                return;
            }
            localVarIndex += argType.getSize();
        }
        this.mv.visitInsn(1);
    }

    protected void onMethodExit(int opcode) {
        if (opcode == 177) {
            this.mv.visitVarInsn(25, this.contextVar);
            this.mv.visitInsn(1);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, TRACE_CLASS, END_METHOD, END_SIGNATURE, false);
        } else if (opcode >= 172 && opcode <= 176) {
            int returnOpcode = this.returnType.getOpcode(21);
            int storeVar = this.newLocal(this.returnType);
            this.mv.visitVarInsn(this.returnType.getOpcode(54), storeVar);
            this.mv.visitVarInsn(returnOpcode, storeVar);
            if (this.returnType.getSort() != 10 && this.returnType.getSort() != 9) {
                this.boxPrimitive(this.returnType);
            }
            int boxedVar = this.newLocal(Type.getType(Object.class));
            this.mv.visitVarInsn(58, boxedVar);
            this.mv.visitVarInsn(25, this.contextVar);
            this.mv.visitVarInsn(25, boxedVar);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, TRACE_CLASS, END_METHOD, END_SIGNATURE, false);
            this.mv.visitVarInsn(returnOpcode, storeVar);
        } else if (opcode == 191) {
            this.mv.visitInsn(89);
            int exceptionVar = this.newLocal(Type.getType(Throwable.class));
            this.mv.visitVarInsn(58, exceptionVar);
            this.mv.visitVarInsn(25, this.contextVar);
            this.mv.visitInsn(1);
            this.mv.visitVarInsn(25, exceptionVar);
            this.mv.visitMethodInsn(184, TRACE_CLASS, END_METHOD, END_SIGNATURE, false);
        }
    }

    private void boxPrimitive(Type primitiveType) {
        switch (primitiveType.getSort()) {
            case 1: {
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 4: {
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 5: {
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 7: {
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 6: {
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 8: {
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            }
        }
    }
}

