/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.rmi;

import whatap.agent.asm.IASM;
import whatap.agent.instrumentation.rmi.RemoteTargetObjectMV;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;

class RemoteTargetObjectCV
extends ClassVisitor
implements Opcodes {
    private final String className;

    public RemoteTargetObjectCV(ClassVisitor cv, String className) {
        super(IASM.API, cv);
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!this.isPublic(access) || this.isStatic(access)) {
            return mv;
        }
        if (this.isSynthetic(access) || this.isBridge(access)) {
            return mv;
        }
        if ("<init>".equals(name) || "<clinit>".equals(name)) {
            return mv;
        }
        if (this.isObjectMethod(name, desc)) {
            return mv;
        }
        return new RemoteTargetObjectMV(mv, access, name, desc, this.className);
    }

    private boolean isPublic(int access) {
        return (access & 1) != 0;
    }

    private boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    private boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    private boolean isBridge(int access) {
        return (access & 0x40) != 0;
    }

    private boolean isObjectMethod(String name, String desc) {
        if ("equals".equals(name) && "(Ljava/lang/Object;)Z".equals(desc)) {
            return true;
        }
        if ("hashCode".equals(name) && "()I".equals(desc)) {
            return true;
        }
        if ("toString".equals(name) && "()Ljava/lang/String;".equals(desc)) {
            return true;
        }
        if ("clone".equals(name) && "()Ljava/lang/Object;".equals(desc)) {
            return true;
        }
        if ("finalize".equals(name) && "()V".equals(desc)) {
            return true;
        }
        if ("wait".equals(name)) {
            return true;
        }
        if ("notify".equals(name) || "notifyAll".equals(name)) {
            return true;
        }
        return "getClass".equals(name) && "()Ljava/lang/Class;".equals(desc);
    }
}

