/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.wrapper;

import whatap.agent.instrumentation.executor.advice.ExecutorContext;
import whatap.agent.trace.TraceContext;

public class ContextPropagatingRunnable
implements Runnable {
    private final Runnable delegate;
    private final ExecutorContext executorContext;

    public ContextPropagatingRunnable(Runnable delegate, ExecutorContext executorContext) {
        this.delegate = delegate;
        this.executorContext = executorContext;
    }

    public void run() {
        TraceContext activeCtx = this.executorContext.activateContext();
        if (activeCtx == null) {
            this.delegate.run();
            return;
        }
        this.updateThreadInfo(activeCtx);
        Throwable error = null;
        try {
            this.delegate.run();
        }
        catch (Throwable t) {
            error = t;
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            this.executorContext.deactivateContext(error);
        }
    }

    private void updateThreadInfo(TraceContext ctx) {
        Thread current = Thread.currentThread();
        long currentId = current.getId();
        if (ctx.threadId != currentId) {
            ctx.thread = current;
            ctx.threadId = currentId;
        }
    }

    public String toString() {
        return "ContextPropagatingRunnable{delegate=" + this.delegate + "}";
    }
}

