/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.wrapper;

import java.util.concurrent.Callable;
import whatap.agent.instrumentation.executor.advice.ExecutorContext;
import whatap.agent.trace.TraceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextPropagatingCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final ExecutorContext executorContext;

    public ContextPropagatingCallable(Callable<V> delegate, ExecutorContext executorContext) {
        this.delegate = delegate;
        this.executorContext = executorContext;
    }

    @Override
    public V call() throws Exception {
        TraceContext activeCtx = this.executorContext.activateContext();
        if (activeCtx == null) {
            return this.delegate.call();
        }
        this.updateThreadInfo(activeCtx);
        Throwable error = null;
        try {
            V v = this.delegate.call();
            return v;
        }
        catch (Throwable t) {
            error = t;
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            this.executorContext.deactivateContext(error);
        }
    }

    private void updateThreadInfo(TraceContext ctx) {
        Thread current = Thread.currentThread();
        long currentId = current.getId();
        if (ctx.threadId != currentId) {
            ctx.thread = current;
            ctx.threadId = currentId;
        }
    }

    public String toString() {
        return "ContextPropagatingCallable{delegate=" + this.delegate + "}";
    }
}

