/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.visitor;

import whatap.agent.asm.IASM;
import whatap.agent.instrumentation.executor.adapter.ExecuteMethodAdapter;
import whatap.agent.instrumentation.executor.adapter.SubmitCallableMethodAdapter;
import whatap.agent.instrumentation.executor.adapter.SubmitMethodAdapter;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;

public class ScheduledExecutorClassVisitor
extends ClassVisitor {
    public ScheduledExecutorClassVisitor(ClassVisitor cv) {
        super(IASM.API, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (name.equals("execute") && descriptor.equals("(Ljava/lang/Runnable;)V")) {
            return new ExecuteMethodAdapter(access, descriptor, mv, "java/util/concurrent/ScheduledThreadPoolExecutor", false);
        }
        if (name.equals("submit") && (descriptor.equals("(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;") || descriptor.equals("(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;"))) {
            return new SubmitMethodAdapter(access, descriptor, mv, "java/util/concurrent/ScheduledThreadPoolExecutor", false);
        }
        if (name.equals("schedule")) {
            if (descriptor.equals("(Ljava/lang/Runnable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;")) {
                return new SubmitMethodAdapter(access, descriptor, mv, "java/util/concurrent/ScheduledThreadPoolExecutor", false);
            }
            if (descriptor.equals("(Ljava/util/concurrent/Callable;JLjava/util/concurrent/TimeUnit;)Ljava/util/concurrent/ScheduledFuture;")) {
                return new SubmitCallableMethodAdapter(access, descriptor, mv, "java/util/concurrent/ScheduledThreadPoolExecutor", false);
            }
        }
        return mv;
    }
}

