/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.visitor;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.conf.ConfInstrumentation;
import whatap.agent.instrumentation.executor.adapter.ExecuteMethodAdapter;
import whatap.agent.instrumentation.executor.adapter.SubmitCallableMethodAdapter;
import whatap.agent.instrumentation.executor.adapter.SubmitMethodAdapter;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;

public class ForkJoinPoolClassVisitor
extends ClassVisitor {
    public ForkJoinPoolClassVisitor(ClassVisitor cv) {
        super(IASM.API, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        boolean debug = ConfInstrumentation.debug_instrumentation_executor_enabled;
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (name.equals("execute") && descriptor.equals("(Ljava/lang/Runnable;)V")) {
            return new ExecuteMethodAdapter(access, descriptor, mv, "java/util/concurrent/ForkJoinPool", false);
        }
        if (name.equals("submit")) {
            if (descriptor.equals("(Ljava/lang/Runnable;)Ljava/util/concurrent/ForkJoinTask;") || descriptor.equals("(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/ForkJoinTask;")) {
                if (debug) {
                    Logger.println("Executor", "FJP submit(Runnable) instrumented");
                }
                return new SubmitMethodAdapter(access, descriptor, mv, "java/util/concurrent/ForkJoinPool", false);
            }
            if (descriptor.equals("(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/ForkJoinTask;")) {
                if (debug) {
                    Logger.println("Executor", "FJP submit(Callable) instrumented");
                }
                return new SubmitCallableMethodAdapter(access, descriptor, mv, "java/util/concurrent/ForkJoinPool", false);
            }
        }
        return mv;
    }
}

