/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.visitor;

import whatap.agent.asm.IASM;
import whatap.agent.instrumentation.executor.adapter.ExecuteMethodAdapter;
import whatap.agent.instrumentation.executor.adapter.SubmitCallableMethodAdapter;
import whatap.agent.instrumentation.executor.adapter.SubmitMethodAdapter;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;

public class ExecutorClassVisitor
extends ClassVisitor {
    private final String owner;

    public ExecutorClassVisitor(ClassVisitor cv, String owner) {
        super(IASM.API, cv);
        this.owner = owner;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (name.equals("execute") && descriptor.equals("(Ljava/lang/Runnable;)V")) {
            return new ExecuteMethodAdapter(access, descriptor, mv, this.owner, false);
        }
        if (name.equals("submit")) {
            if (descriptor.equals("(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;") || descriptor.equals("(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;")) {
                return new SubmitMethodAdapter(access, descriptor, mv, this.owner, false);
            }
            if (descriptor.equals("(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;")) {
                return new SubmitCallableMethodAdapter(access, descriptor, mv, this.owner, false);
            }
        }
        return mv;
    }
}

