/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.visitor;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.conf.ConfInstrumentation;
import whatap.agent.instrumentation.executor.adapter.SubmitCallableMethodAdapter;
import whatap.agent.instrumentation.executor.adapter.SubmitMethodAdapter;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;

public class AbstractExecutorServiceClassVisitor
extends ClassVisitor {
    private final String owner;

    public AbstractExecutorServiceClassVisitor(ClassVisitor cv, String owner) {
        super(IASM.API, cv);
        this.owner = owner;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        boolean debug = ConfInstrumentation.debug_instrumentation_executor_enabled;
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (name.equals("submit")) {
            if (descriptor.equals("(Ljava/lang/Runnable;)Ljava/util/concurrent/Future;") || descriptor.equals("(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;")) {
                if (debug) {
                    Logger.println("Executor", "AES submit(Runnable) instrumented, owner=" + this.owner);
                }
                return new SubmitMethodAdapter(access, descriptor, mv, this.owner, false);
            }
            if (descriptor.equals("(Ljava/util/concurrent/Callable;)Ljava/util/concurrent/Future;")) {
                if (debug) {
                    Logger.println("Executor", "AES submit(Callable) instrumented, owner=" + this.owner);
                }
                return new SubmitCallableMethodAdapter(access, descriptor, mv, this.owner, false);
            }
        }
        return mv;
    }
}

