/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.instrumentation.executor.advice;

import java.util.concurrent.atomic.AtomicBoolean;
import whatap.agent.Logger;
import whatap.agent.api.trace.TxTraceBackground;
import whatap.agent.conf.ConfInstrumentation;
import whatap.agent.conf.ConfTrace;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;

public class ExecutorContext {
    public final TraceContext parentContext;
    public final long submitTime;
    public final String submitThreadName;
    public String taskName;
    public TraceContext childContext;
    private final AtomicBoolean activated = new AtomicBoolean(false);

    public ExecutorContext(TraceContext parentContext) {
        this.parentContext = parentContext;
        this.submitTime = System.currentTimeMillis();
        this.submitThreadName = Thread.currentThread().getName();
        this.taskName = "UnknownTask";
    }

    public void initChildTransaction(String taskName) {
        if (this.childContext != null) {
            return;
        }
        this.taskName = taskName;
        this.childContext = TxTraceBackground.startTxForExecutor(this.parentContext, taskName);
        if (this.childContext != null) {
            if (ConfTrace.trace_executor_background_enabled) {
                this.childContext.addActiveTxListEnabled = false;
            }
            if (ConfInstrumentation.debug_instrumentation_executor_enabled) {
                Logger.println("Executor", "initChildTransaction txid=" + this.childContext.txid + ", mcaller_txid=" + this.childContext.mcaller_txid + ", task=" + taskName);
            }
        }
    }

    public TraceContext activateContext() {
        if (!this.activated.compareAndSet(false, true)) {
            return null;
        }
        if (this.childContext == null) {
            this.initChildTransaction(this.taskName);
        }
        if (this.childContext != null) {
            TraceContextManager.start(this.childContext);
            return this.childContext;
        }
        return null;
    }

    public void deactivateContext(Throwable error) {
        if (!this.activated.get()) {
            return;
        }
        try {
            if (this.childContext != null) {
                TxTraceBackground.endTx(this.childContext, null, error);
            }
        }
        finally {
            if (this.childContext != null) {
                TraceContextManager.end(this.childContext.txid);
            } else {
                TraceContextManager.detach();
            }
        }
    }

    public String toString() {
        return "ExecutorContext{taskName='" + this.taskName + '\'' + ", submitTime=" + this.submitTime + ", submitThread='" + this.submitThreadName + '\'' + '}';
    }
}

